/**
 * @author Ravi Choudhary
 */
Ext.define('Academia.view.examinationcenters.reports.GradeWiseReportGrid', {
	//  extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.gradewisereportgrid',
	store: 'examinationcenters.reports.GradeWiseReportStore',
	title: getExaminationTranslation("GRADE_WISE_REPORT_LIST"),
	border: true,
	refreshStoreData:true,
	frame:false,
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'examinationreports':1
		}
	},
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	 dockedItems: [{
	    	xtype : 'toolbar',
	    	dock : 'bottom',
	    	items : [ {
	    	    xtype : 'custompagingtoolbar',
	    	    plugins:['pagesize'],
	    	    store : 'examinationcenters.reports.GradeWiseReportStore',
	    	    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
	    	    displayInfo : true
	    	} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid, false);
		this.callParent(arguments);     
	},
    tbar : [{
	   xtype : 'button',
	   itemId : 'exportReportId',
	   tooltip : getCommonTranslation('EXPORTREPORTS'),
	   text : getCommonTranslation('EXPORTREPORTS'),
	   formBind:true,
    }],
	columns: [{
		header:  getExaminationTranslation('PROGRAM_NAME'),
		dataIndex: 'programName',
		flex:.1,
		sortable:true
	},{
		header:  getExaminationTranslation('BATCH_NAME'),
		dataIndex: 'batchName',
		flex:.1,
		sortable:true
	},{
		header:  getExaminationTranslation('PERIOD_NAME'),
		dataIndex: 'periodName',
		flex:.1,
		sortable:true,
		hidden:true
	},{
		header:  getExaminationTranslation('COURSE_NAME'),
		dataIndex: 'courseName',
		flex:.1,
		sortable:true
	},{
		header:  getExaminationTranslation('GRADE_RANGE'),
		dataIndex: 'gradeRangeFromTo',
		flex:.1,
		sortable:true,
		hidden:true
	},{
		header:  getExaminationTranslation('GRADE'),
		dataIndex: 'grade',
		flex:.1,
		sortable:true,
	},{
		header:  getExaminationTranslation('GRADE_POINT'),
		dataIndex: 'gradePoint',
		flex:.1,
		sortable:true,
		hidden:true
	},{
		header:  getExaminationTranslation('NO_OF_STUDENT'),
		dataIndex: 'noOfStudent',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(record.data.noOfStudent == 0){
				return record.data.noOfStudent ;
			} else {
				return '<a href=#>'+record.data.noOfStudent +'</a>'
			}
		}
	}]
});
