/**
 * @author Ravi Choudhary
 */
Ext.define('Academia.view.examinationcenters.reports.GradeWiseStudentGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.gradewisestudentgrid',
	store: 'examinationcenters.reports.GradeWiseStudentStore',
	title:getCommonTranslation('STUDENT_LIST'),
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	frame:false,
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'examinationreports':1
		}
	},
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	 dockedItems: [{
	    	xtype : 'toolbar',
	    	dock : 'bottom',
	    	items : [ {
	    	    xtype : 'custompagingtoolbar',
	    	    plugins:['pagesize'],
	    	    store : 'examinationcenters.reports.GradeWiseStudentStore',
	    	    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
	    	    displayInfo : true
	    	} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	columns: [{
		header:  getExaminationTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				if(record.data.studentId == 0){
					return value;
				} else {
					 return '<a href=#>'+value+'</a>'
				}
			}                        
		}
	},{
		header:  getExaminationTranslation('ADMISSION_NUMBER'),
		dataIndex: 'enrollmentNo',
		flex:.19,
		sortable:true,
	},{
		header:  getExaminationTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.1,
		sortable:true,
	},/*{
		header:  getExaminationTranslation('MARKS_OBTAINED'),
		dataIndex: 'marksObtained',
		flex:.1,
		sortable:true,
	},*/{
		header:  getExaminationTranslation('GRADE'),
		dataIndex: 'grade',
		flex:.1,
		sortable:true,
	},/*{
		header:  getExaminationTranslation('COURSE_RANK'),
		dataIndex: 'courseRank',
		flex:.1,
		sortable:true,
	}*/]
});
