/**
 * Kuldeep Yadav 
 */
Ext.define('Academia.view.examinationcenters.reports.PendingMarksRemarksResultGrid', {
	// extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport', 
	alias: 'widget.pendingmarksremarksresultgrid',
	store: 'examinationcenters.reports.PendingMarksStore',
	title: getExaminationTranslation('PENDING_MARK_ENTRY'),
	border: true,
	isGridConfigurable: true,
	enableColumnHide: false,
	//maxHeight: 700,
	frame:false,
	viewConfig: {
		stripeRows: false
	},
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			// store: 'examinationcenters.evaluation.coverageDetails.CoverageDetailsGrid',
			store: 'examinationcenters.reports.PendingMarksStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar:[
//		{
//	xtype: 'button',
//		text: getExaminationTranslation('PERMIT_STUDENT'),
//		itemId: 'btnPermitSubmit',
//		//ui: 'CustomBtnSubmit',
//		scale: CONSTANTS.BUTTONSIZE
//		}
		{
			xtype: 'button',
			text: getCommonTranslation('SEND_MESSAGE'),
			itemId: 'sendMessagePendingMarkRemark',
			//ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		}

		],
		columns: [{
			header: getCommonTranslation('PROGRAM_NAME'),
			dataIndex: 'programName',
			flex:.3,
			sortable: true
		}, {
			header: getCommonTranslation('BATCH_NAME'),
			dataIndex: 'batchName',
			flex:.3,
			sortable: true
		},{
			header: getCommonTranslation('PERIOD'),
			dataIndex: 'periodName',
			flex:.3,
			sortable: true,
		},{
			header: getCommonTranslation('SECTION'),
			dataIndex: 'sectionName',
			flex:.3,
			sortable: true
		},{
			header: getCommonTranslation('COURSE_CODE'),
			dataIndex: 'courseCode',
			flex:.3,
			sortable: true,
		},{
			header: getCommonTranslation('COURSE'),
			dataIndex: 'courseName',
			flex:.3,
			sortable: true
		},{
			header: getCommonTranslation('COURSE_VARIANT'),
			dataIndex: 'courseVariantName',
			flex:.3,
			sortable: true
		}, {
			header: getCommonTranslation('EVALUATION_PLAN'),
			dataIndex: 'evaluationPlanName',
			flex:.3,
			sortable: true,
		}, {
			header: getCommonTranslation('EVALUATION_LEVEL'),
			dataIndex: 'levelName',
			flex:.3,
			sortable: true
		}, {
			header: getCommonTranslation('EVALUATION_LEVEL_NAME'),
			dataIndex: 'levelValue',
			flex:.3,
			sortable: true,
		}, {
			header: getCommonTranslation('EVAL_DETAILED_SEQUENCE'),
			dataIndex: 'eventName',
			flex:.3,
			sortable: true,
			renderer:function(value,meta,record){
				if(record.data.whetherDynamicScheme){
					return record.data.examEventName;
				}else{
					return value;
				}
			}
		},{
			header: getCommonTranslation('FACULTY_NAME'),
			dataIndex: 'facultyName',
			flex:.3,
			sortable: true,
		},{
			header: getCommonTranslation('TOTAL_STUDENTS'),
			dataIndex: 'totalStudents',
			flex:.3,
			sortable: true,
		},{
			header: getCommonTranslation('MARK_ENTRIES_DONE'),
			dataIndex: 'markEntryDone',
			flex:.3,
			sortable: true,
			renderer:function(value,meta,record){
				if(value==0){
					return value;
				}
				else {
					return '<a href=#>'+value+'</a>'
				}
			}
		},{
			header: getCommonTranslation('SAVED_MARK_ENTRIES'),
			dataIndex: 'savedMarkEntries',
			flex:.3,
			sortable: true,
			renderer:function(value,meta,record){
				if(value==0){
					return value;
				}
				else {
					return '<a href=#>'+value+'</a>'
				}
			}
		},{
			header: getCommonTranslation('PENDING_MARK_ENTRIES'),
			dataIndex: 'remainingMarkEntries',
			flex:.3,
			sortable: true,
			renderer:function(value,meta,record){
				if(value==0){
					return value;
				}
				else {
					return '<a href=#>'+value+'</a>'
				}
			}
		},{
			header: getCommonTranslation('ACADEMIC_TERM'),
			dataIndex: 'academicTerm',
			flex:.3,
			hidden:true
		},],
		plugins: [{
			ptype : 'cellediting',
			clicksToEdit: 1
		}]
});
