/**
 * Kuldeep Yadav 
 */
Ext.define('Academia.view.examinationcenters.reports.PendingRemarksResultGrid', {
   // extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport', 
    alias: 'widget.pendingremarksresultgrid',
    store: 'examinationcenters.reports.PendingRemarksStore',
    title: getExaminationTranslation('PENDING_REMARKS_ENTRY'),
    border: true,
    autoScroll: false,
    isGridConfigurable: true,
    enableColumnHide: false,
    frame:false,
    viewConfig: {
        stripeRows: false
    },
    selType:'checkboxmodel',
    selModel: {
    	mode:'MULTI',
    	showHeaderCheckbox: true,
    	allowDeselect: false,
    	checkOnly : true
    },
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			// store: 'examinationcenters.evaluation.coverageDetails.CoverageDetailsGrid',
            store: 'examinationcenters.reports.PendingRemarksStore',
        	emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
   },
    tbar:[
//    	 {
//        	xtype: 'button',
//            text: getExaminationTranslation('PERMIT_STUDENT'),
//            itemId: 'btnPermitSubmit',
//            //ui: 'CustomBtnSubmit',
//            scale: CONSTANTS.BUTTONSIZE
//        }
    	
    	{
    		xtype: 'button',
    		text: getCommonTranslation('SEND_MESSAGE'),
    		itemId: 'sendMessagePendingRemark',
    		//ui: 'CustomBtnSubmit',
    		scale: CONSTANTS.BUTTONSIZE
    	}
    ],
    columns: [{
        header: getCommonTranslation('PROGRAM'),
        dataIndex: 'programName',
        flex:.3,
        sortable: true
    }, {
        header: getCommonTranslation('BATCH'),
        dataIndex: 'batchName',
        flex:.3,
        sortable: true
    },{
        header: getCommonTranslation('PERIOD'),
        dataIndex: 'periodName',
        flex:.3,
        sortable: true
    },{
        header: getCommonTranslation('SECTION'),
        dataIndex: 'sectionName',
        flex:.3,
        sortable: true
    },{
        header: getCommonTranslation('COURSE_CODE'),
        dataIndex: 'courseCode',
        flex:.3,
        sortable: true
    },{
        header: getCommonTranslation('COURSE'),
        dataIndex: 'courseName',
        flex:.3,
        sortable: true
    },{
        header: getCommonTranslation('COURSE_VARIANT'),
        dataIndex: 'courseVariantName',
        flex:.3,
        sortable: true
    }/*,{
        header: getExaminationTranslation('DETAILED_SEQUENCE'),
        dataIndex: 'eventName',
        flex:.3,
        sortable: true
    }*//*,{
        header: getExaminationTranslation('LEVEL_TYPE'),
        dataIndex: 'planLevelType',
        flex:.3,
        sortable: true
    },{
        header: getExaminationTranslation('LEVEL_NAME'),
        dataIndex: 'planLevelName',
        flex:.3,
        sortable: true
    }*/,{
        header: getCommonTranslation('EVALUATION_PLAN'),
        dataIndex: 'evaluationPlanName',
        flex:.3,
        sortable: true,
    	/*renderer:function(value,meta,record){
			return value+"%";
		}*/
    },{
        header: getCommonTranslation('EVALUATION_LEVEL'),
        dataIndex: 'levelName',
        flex:.3,
        sortable: true,
    },{
        header: getCommonTranslation('EVALUATION_LEVEL_NAME'),
        dataIndex: 'levelValue',
        flex:.3,
        sortable: true,
    },{
        header: getCommonTranslation('FACULTY_NAME'),
        dataIndex: 'facultyName',
        flex:.3,
        sortable: true,
    },{
        header: getCommonTranslation('TOTAL_STUDENTS'),
        dataIndex: 'totalStudents',
        flex:.3,
        sortable: true,
    },{
        header: getCommonTranslation('REMARKS_ENTRY_DONE'),
        dataIndex: 'remarkEntryDone',
        flex:.3,
        sortable: true,
    },{
        header: getCommonTranslation('REMAINING_REMARKS_ENTRIES'),
        dataIndex: 'remainingRemarkEntries',
        flex:.3,        sortable: true,
        renderer:function(value,meta,record){
        		if(value==0){
        			return value
        		}
        		else
        			return '<a href=#>'+value+'</a>'
		}
    }],
    plugins: [{
   	  ptype : 'cellediting',
   	  clicksToEdit: 1
     }]
});
