/**
 * @author Vinay  Kumrawat
 */
Ext.define('Academia.view.examinationcenters.reports.StudentAssementReportTypeWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.studentassementreporttypewin',
	title: getCommonTranslation("EXPORT_REPORT"),
	modal: true,
	autoScroll:true,
	maxHeight:500,
	width: 350,
	height:160,
	items: [{
		xtype: 'form',
		itemId:'windowForm',
		method: 'POST',
		margin: 0,
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			autoScroll:true,
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype: 'fieldcontainer',
			width: '100%',
			layout: {
				type: 'hbox'
			},
			items: [{
            	xtype: 'customcombobox',
            	itemId:'chooseTemplateId',
        		name: 'chooseTemplate',
        	    store:'setup.templatemapping.TemplateNameListFacultyByCode',//'examinationcenters.marksheet.MarksheetGenerationTemplate',
        		displayField:'code',
        		valueField:'id',
        		forceSelection:true,
        		typeAhead:true,
        		minChars:3,
        		listConfig: {
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				},
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				}
    			},
        		allowBlank:false,
        		fieldLabel:getExaminationTranslation('TEMPLATE'),
        		width: 300
            }]
		},
		{
			xtype: 'fieldcontainer',    
			layout : {
				type : 'hbox'
			},
			width:'auto',
			items : [{
				xtype : 'button',
				text : getCommonTranslation("DOWNLOAD_REPORT") ,
				itemId : 'downloadReportId',
				name: 'downloadReport',
				ui : 'CustomBtnSubmit',
				margin: '5px 0px 0px 5px',
				scale : CONSTANTS.BUTTONSIZE,
				formBind : true
			}]
		}]
	}]
	
});