/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.view.examinationcenters.reports.StudentAssessmentReportFilter', {
	extend: 'Ext.form.FormPanel',
    alias: 'widget.studentassessmentreportfilter',
    autoScroll: false,
    cls:'customSearchPanel',
    standardSubmit : false,
    //title: getCommonTranslation('SEARCH'),
    collapsible: true,
    modal: true,
    //border:true,
    plugins : "formlabelrequired",
	    items: [{
	    	xtype: 'fieldcontainer',
	        layout: 'hbox',
	        margin: '3 0 0 0',
	        defaults: {
	            width: 256,
	            labelAlign: 'top',
	        },
	        items: [{
				xtype: 'customcombobox',
				name: 'studentId',
				itemId: 'studentItemId',
				store:'examinationcenters.reports.StudentAsseessmentReportStudentListStore',
				fieldLabel:getExaminationTranslation('ADMISSION_CODE_STD_NAME_STD_CODE'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'studentName',
				minChars:3,
				width: 536,
				typeAhead:false,
				triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
				triggerAction: '',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}' +
						'</div>';
					}
				}
			}, {
				xtype: 'customcombobox',
				name:'programId',
				itemId:'programItemId',
				store:'examinationcenters.reports.ExaminationReportProgramStore',
				fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),	
				valueField: 'id',
				displayField: 'valueSecondValue',
				queryParam:'name',
				minChars:3,
				//width: 536,
				allowBlank:false,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					},
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
				}
			}]
	    },
	    {
	    	xtype: 'fieldcontainer',
	        layout: 'hbox',
	        defaults: {
	            width: 256,
	            labelAlign: 'top'
	        },
	        items: [{
				xtype: 'customcombobox',
				name:'batchId',
				itemId:'batchItemId',
				store:'examinationcenters.reports.ExaminationReportBatchStore',
				fieldLabel:getExaminationTranslation('BATCH'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				minChars:3,
				//width: 256,
				disabled:true,
				//uncomment for V2D-81023 bug
				allowBlank:false,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					},
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
				}
			},{
	        	xtype: 'customcombobox',
	            name: 'periodId',
	            itemId: 'periodItemId',
	            store:'examinationcenters.reports.ExaminationReportPeriodStore',
	            displayField:'value',
	            valueField:'id',
	            queryParam:'name',
	            minChars:3,
	            disabled : true,
	            fieldLabel:getExaminationTranslation('PERIOD'),
	           // allowBlank:false,
	            typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					},
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
				}
	        },{
				xtype: 'customcombobox',
				name: 'sectionId',
				itemId: 'sectionItemId',
				store:'examinationcenters.reports.BatchSectionStore',
				fieldLabel:getExaminationTranslation('SECTION'),
				valueField: 'id',
				minChars:3,
				displayField: 'value',
				queryParam:'name',
				//width: 536,
				disabled:true,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				//editible:false
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					},
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
				}
			}]
	    },{   
	    	xtype: 'fieldcontainer',
	        layout: 'hbox',
	        defaults: {
	            width: 256,
	            labelAlign: 'top'
	        },
				items:[{
					xtype: 'customcombobox',
					name: 'evaluationLevel',
					itemId: 'evaluationLevelItemId',
					store:'examinationcenters.marksheet.StudentAssessmentEvaluationLevelType',
					displayField:'value',
					valueField:'id',
					forceSelection:true,
					typeAhead:true,
					minChars:3,
					width: 256,
					fieldLabel:getExaminationTranslation('EVALUATION_PLAN_LEVEL'),
					disabled:true,
				},{
					xtype: 'multiselectcombofield',
					name: 'evalLevelName',
					itemId: 'evalLevelName',
					fieldLabel:getExaminationTranslation('EVALUATION_LEVEL_NAME'),
					store:'examinationcenters.assessmentEvent.StudentAssessmentLevelListStore',
					displayField:'value',
					valueField:'id',
					minChars:3,
					typeAhead:true,
					triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
					enableKeyEvents  : 'true',
					hideTrigger:false,
					forceSelection:true,
					allowBlank:false,
					disabled:true,
					width: 536,
					maxLength:9999,
					maxSelections :9999,
				    cls:'commonAutoHeightMultiselectField placementProgramMultiselect',				
					listConfig: {
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						},
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						}
					}
					
		    	}]
			},{
				xtype:'fieldcontainer',
				width:'100%',
				layout:'hbox',
				style:{marginTop:'20px !important'},
				defaults:{
					labelAlign:'top',
					width: 256,
					
				},
				items:[{
					xtype: 'customcombobox',
					name: 'courseId',
					itemId: 'courseItemId',
					store:'examinationcenters.reports.ExaminationAssesmentReportCourseUpdatedStore',
					fieldLabel:getCommonTranslation('COURSE_CODE_NAME'),
					valueField: 'courseId',
					displayField: 'courseValue',   
					queryParam:'courseName',
					minChars:3,
					width: 536,
					typeAhead:false,
					triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
					triggerAction: '',
					enableKeyEvents  : 'true',
					hideTrigger:false,
					forceSelection:true,
					style:{marginLeft:'10px'},
					disabled:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						},
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
								picker.maxWidth = picker.up('combobox').getSize().width; 
							}
						},						keyup: function (combo, e) {

						       var query = combo.getRawValue();

						       if (query.length < 3) {
						           combo.getStore().removeAll();
						           return;
						       }

						       var form = combo.up('form').getForm();
						       var academyLocationId = form.findField("academyLocationId").getValue();
						       var admissionId = form.findField("studentId").getValue();
						       var programId = form.findField("programId").getValue();
						       var batchId = form.findField("batchId").getValue();
						       var periodId = form.findField("periodId").getValue();
						       var facultyId = form.findField("facultyId") ? form.findField("facultyId").getValue() : null;

							   courseId.getStore().getProxy().extraParams = {
							      academyLocationId: academyLocationId,
							      admissionId: admissionId,
							      programId: programId,
							      batchId: batchId,
							      periodId: periodId,
							      facultyId: facultyId,
							      page: 1,
							      limit: 500
							   };
						   }
					}
				},{
		        	xtype: 'customcombobox',
		            name: 'courseVariant',
		            itemId:'courseVariantItemId',
		            store:'facilitiesresources.resourcebooking.CourseVariantsListStore',
		            displayField:'code',
		            queryParam:'courseName',
		            valueField:'id',
		            width: 256,
		            minChars:3,
		            typeAhead:false,
					forceSelection:true,
					disabled:true,
					listConfig: {
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{code}' +
							'</div>';
						},
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
					},
		            fieldLabel:getExaminationTranslation('COURSE_VARIANT')
		        }]
	    },{
		    xtype: 'fieldcontainer',
	        width:'100%',
			cls: 'customSearchPanelBtnsFieldContainerCls',
    		layout : {
    			type : 'hbox'
    		},
	        items: [ {
	            xtype: 'button',
	            itemId:'searchBtn',
	            text: getCommonTranslation('SEARCH'),
	            ui: 'CustomBtnSubmit',
	            scale: CONSTANTS.BUTTONSIZE,
	            formBind:true
	        },{
	            xtype: 'button',
	            text: getCommonTranslation('RESET'),
	            itemId:'resetBtn',
	            ui: 'CustomBtnCancel',
	            scale: CONSTANTS.BUTTONSIZE
	        }]
	   }]
});