/**
 * @author Kuldeep Yadav
 */
Ext.define('Academia.view.examinationcenters.reports.StudentAssessmentReportWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.studentassessmentreportwin',
	//title: getCommonTranslation("SELECT_ASSESSMENT_STUDENT_REPORT_TEMPLATE"),
	modal: true,
	autoScroll:true,
	maxHeight:500,
	width: '40%',
	height:'20%',
	minWidth: 510,
	items: [{
		xtype: 'form',
		method: 'POST',
		margin: 0,
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			autoScroll:true
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox',
        		width: 256
			},
			items: [{
            	xtype: 'customcombobox',
            	itemId:'chooseHallticketTemplate',
        		name: 'chooseHallticketTemplateId',
        	    store:'setup.templatemapping.TemplateNameListFacultyByCode',//'examinationcenters.marksheet.MarksheetGenerationTemplate',
        		displayField:'code',
        		valueField:'id',
        		forceSelection:true,
        		typeAhead:true,
        		minChars:3,
        		listConfig: {
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				},
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				}
    			},
        		allowBlank:false,
        		fieldLabel:getExaminationTranslation('TEMPLATE')
            },{
    	        xtype: 'fieldcontainer',
            	layout: 'hbox',
            	margin: '0 0 0 16',
            	items:[{
            		xtype: 'button',
        			text:'Preview Template',
        			itemId: 'previewTemplateBtn',
        			buttonAlign: 'bottom',
        			ui: 'CustomBtnThird',
        			scale: CONSTANTS.BUTTONSIZE
        			//hidden:true
        			//formBind:true
            	}]
    		}]
		},{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox',
        		width: 256
			},
			items: [{
            	xtype: 'datefield',
            	itemId:'publishDateItemId',
        		name: 'publishDate',
        		allowBlank:false,
        		submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
        		disabled: true,
    			listeners: {
    				render: function(field) {
    					Ext.defer(function() {
    						field.setWidth(field.getWidth() - 1);
    					}, 100);
    					return dateFormatRender(field);
    				}
    			},
        		fieldLabel : getExaminationTranslation('PUBLISH_DATE')
            }]
		},{
			xtype: 'fieldcontainer',    
			layout : {
				type : 'hbox'
			},
			width:'auto',
			items : [{
				xtype : 'button',
				text : getCommonTranslation("GENERATE") ,
				itemId : 'submitBtn',
				ui : 'CustomBtnSubmit',
				margin: '5px 0px 0px 105px',
				scale : CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
				xtype : 'button',
				text : getCommonTranslation("GENERATE_AND_PUBLISH") ,
				itemId : 'generateAndPublishBtn',
				ui : 'CustomBtnSubmit',
				margin: '5px 0px 0px 5px',
				scale : CONSTANTS.BUTTONSIZE,
				disabled: true
			},{
                xtype: 'button',
                text: getServiceRequestTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                itemId: 'cancelButtonId',
                scale: CONSTANTS.BUTTONSIZE,
                margin: '5px 0px 0px 5px',
                listeners: {
					click: function(obj) {
						obj.up().up().up().close();
					}
                }
            }]
		}]
	}]
});