/**
 * @author Deepika P
 */
Ext.define('Academia.view.examinationcenters.reports.StudentLevelRemarkReportFilter',{
	extend:'Ext.form.FormPanel',
	alias:'widget.studentlevelremarkreportfilter',
	plugins:"formlabelrequired",
	autoScroll:false,
	frame:false,
	cls:'customSearchPanel',
	method:'POST',
	standardSubmit:false,
	isMinWidthNotRequired: true,
	defaults:{
		labelAlign:'top',
		width: 256
	},
	items:[{
		
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 256
	},items:[{
		xtype:'hidden',
		name:'eventStatus',
		itemId: 'eventStatus',
		},{
		xtype: 'customcombobox',
		name:'userType',
		itemId:'userTypeId',
		store:Ext.create('Academia.store.examinationcenters.remark.StudentRemarkUserTypeStore'),
		fieldLabel:getCommonTranslation('USER_TYPE'),
		valueField: 'id',
		displayField: 'value',
		forceSelection:true,
		width: 256,
		typeAhead:false,
		allowBlank:false,
		listConfig: {
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}' +
				'</div>';
			},
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
		}
	},{
		xtype : 'customcombobox',
		name : 'academicTerm',
		itemId : 'academicTerm',
		fieldLabel : getCommonTranslation('ACADEMIC_TERM'),
		store:Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
		valueField : 'id',
		displayField : 'value',
		allowBlank:false,
		forceSelection:true,
		
    },{
		xtype: 'customcombobox',
		name:'programId',
		itemId:'programItemId',
		store:Ext.create('Academia.store.facilitiesresources.resourcebooking.AllProgramsStore'),
		fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
		valueField: 'id',
		displayField: 'valueSecondValue',
		queryParam:'programName',
		minChars:3,
		allowBlank:false,
		triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
		enableKeyEvents  : 'true',
		hideTrigger:false,
		forceSelection:true,
		disabled:true,
		//emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		listConfig: {
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}' +
				'</div>';
			},
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
		}
	}]
	},{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype: 'customcombobox',
			name:'batchId',
			itemId:'batchItemId',
			store:Ext.create('Academia.store.common.CurrentBatchStore'),
			fieldLabel:getExaminationTranslation('BATCH'),
			valueField: 'id',
			displayField: 'value',
			width: 256,
			disabled:true,
			allowBlank:false,
			typeAhead:false,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		},{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId: 'periodItemId',
			//disabled:true,
			store:Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod'),
			fieldLabel:getExaminationTranslation('PERIOD'),
			valueField: 'id',
			displayField: 'value',
			width: 256,
			typeAhead:false,
			allowBlank:false,
			disabled:true,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		},{
    		xtype: 'customcombobox',
    		name: 'sectionId',
    		itemId: 'sectionItemId',
    	    store:Ext.create('Academia.store.attendance.SectionAndFacultyByPeriodID'),
    		displayField:'sectionCode',
    		valueField:'sectionId',
    		forceSelection:true,
    		typeAhead:true,
    		minChars:3,
    		fieldLabel:getExaminationTranslation('SECTION'),
			cls:'resetPasswordMultiselect',
    		width: 256,
    		autoloadStore: false,
    		disabled:true,
    		listConfig: {
  				listeners: {
 					beforeshow: function(picker) {
 						picker.minWidth = picker.up('combobox').getSize().width;
 					}
 				},
             }
    	}]
	},{	
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 256
		},
		items:[{
        	xtype: 'customcombobox',
			name:'evaluationPlan',
			itemId:'evaluationPlanItemId',
			store:Ext.create('Academia.store.examinationcenters.evaluation.EvaluationPlanRemarkStore'),
			fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
			valueField: 'id',
			displayField: 'value',
			forceSelection:true,
			minChars:3,	
			disabled:true,
			allowBlank:false,
			typeAhead:true,
		},{
    		xtype: 'customcombobox',
    		name: 'evaluationLevel',
    		itemId: 'evaluationLevelItemId',
    	    store:Ext.create('Academia.store.examinationcenters.marksheet.FindEvaluationLevelTypeNameByPeriodIdStore'),
    	    displayField:'value',
    		valueField:'id',
    		forceSelection:true,
    		typeAhead:true,
    		minChars:3,
    		fieldLabel:getExaminationTranslation('EVALUATION_PLAN_LEVEL'),
    		disabled:true,
    		allowBlank:false
    	},{
    		xtype: 'customcombobox',
    		name: 'evalLevelName',
    		itemId: 'evaluationLevelNameItemId',
//    	    store:'examinationcenters.marksheet.EvaluationLevelForTeacherRemarkStore',
    	    store:Ext.create('Academia.store.examinationcenters.remark.EvaluationLevelForTeacherRemarkStore'),
    	    displayField:'value',
    		valueField:'id',
    		forceSelection:true,
    		typeAhead:true,
    		minChars:3,
    		fieldLabel:getExaminationTranslation('EVALUATION_LEVEL_NAME'),
    		maxLength:1000000,
    		autoloadStore: false,
    		allowBlank:false,
    		disabled:true
    	}
    	
    	]},{
    		
    		xtype:'fieldcontainer',
    		width: '100%',
    		layout : 'hbox',
    		defaults: {
    			labelAlign:'top',
    			
    		},
    		items:[{
    			xtype: 'customcombobox',
    			name:'studentIdName',
    			itemId:'studentIdName',
    			width: 536,
    			store:Ext.create('Academia.store.examinationcenters.reports.StudentLevelStudentListStore'),
    			fieldLabel:getExaminationTranslation('STUDENTID_STUDENTNAME'),
    			valueField: 'id',
    			displayField: 'value',
    			queryParam:'name',
    			minChars:3,
    			typeAhead:true,
    			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
    			enableKeyEvents  : 'true',
    			hideTrigger:false,
    			forceSelection:true,
    			disabled:true,
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				}
    			}
            
    		}]
    	}, {
			xtype : 'fieldcontainer',
			width : 'auto',
			cls: 'customSearchPanelBtnsFieldContainerCls',
			layout: 'hbox',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchBtn',
				//buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'resetBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]	
		}]
	});
