/**
 * @author Bhanu Pratap Singh
 */
Ext.define('Academia.view.examinationcenters.reports.StudentReportForm',{
	extend:'Ext.form.FormPanel',
	alias:'widget.studentreportform',
	autoScroll:false,
	frame:false,
	cls:'customSearchPanel',
	method:'POST',
	standardSubmit:false,
	isMinWidthNotRequired: true,
	defaults:{
		labelAlign:'top',
		width: 256
	},
	plugins:"formlabelrequired",
	items:[{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width: 256
		},
		items:[{
		    	   xtype: 'datefield',
		    	   name: 'fromdate',
		    	   itemId:'fromdataItemId',
		    	    editable:false,
		    	   fieldLabel:getExaminationTranslation('FROM_DATE'),
		    	 //--submitFormat:CONSTANTS.DATE_TIME_FORMAT,
		    	   listeners: {
		    		   render: function(field) {
		    			   return dateFormatRender(field);
		    		   }
		    	   }
		       },{
		    	   xtype: 'datefield',
		    	   name: 'tilldate',
		    	   itemId:'tilldateItemId',
		    	    editable:false,
		    	   fieldLabel:getExaminationTranslation('TILL_DATE'),
		    	 //--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
		    	   listeners: {
		    		   render: function(field) {
		    			   return dateFormatRender(field);
		    		   }
		    	   }
		       },	
			   
			   {
			       xtype: 'component',
			       html: '<div data-qtip="' + getCommonTranslation('DATE_RANGE_METADATA') + '" ' +
			             'style="cursor:pointer; margin-top:5px; margin-left:5px;">' +
			                 '<svg xmlns="http://www.w3.org/2000/svg" width="25" height="75" viewBox="0 0 24 24" fill="none" ' +
			                 'stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" ' +
			                 'class="icon icon-tabler icons-tabler-outline icon-tabler-info-square-rounded">' +
			                     '<path stroke="none" d="M0 0h24v24H0z" fill="none"></path>' +
			                     '<path d="M12 9h.01"></path>' +
			                     '<path d="M11 12h1v4h1"></path>' +
			                     '<path d="M12 3c7.2 0 9 1.8 9 9s-1.8 9 -9 9s-9 -1.8 -9 -9s1.8 -9 9 -9z"></path>' +
			                 '</svg>' +
			             '</div>'
			   }

		   ]
	},{
		xtype:'fieldset',
		title: getTransportTranslation('MORE_FILTERS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		style:{marginTop: '33px!important'},
		width:'100%',
		items: [{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width:'100%',
			defaults: {
				width: 536,
				labelAlign: 'top',
			},
			items:[{
				xtype: 'multiselectcombofield',
				itemId: 'userItemId',
				name: 'usersId',
				fieldLabel: getTransportTranslation('USER'),
				store:'examinationcenters.reports.ExaminationReportUserStore',	    
				valueField: 'id',
				displayField: 'value',
				width: 536
			}]
		},
		{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 536
			},
			items:[{
				xtype: 'customcombobox',
				name:'programId',
				itemId:'programItemId',
				store:'examinationcenters.reports.ExaminationReportProgramStore',
				fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'name',
				minChars:3,
				width: 536,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name:'batchId',
				itemId:'batchItemId',
				store:'examinationcenters.reports.ExaminationReportBatchStore',
				fieldLabel:getExaminationTranslation('BATCH'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				minChars:3,
				disabled:true,
				width: 256,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			}]	
		},
		{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 536
			},
			items:[{
				xtype: 'customcombobox',
				name: 'periodId',
				itemId: 'periodItemId',
				store:'examinationcenters.reports.ExaminationReportPeriodStore',
				fieldLabel:getExaminationTranslation('PERIOD'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				disabled:true,
				minChars:3,
				width: 256,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
				xtype: 'multiselectcombofield',
				name: 'sectionId',
				itemId: 'sectionItemId',
				store:'examinationcenters.reports.ExaminationReportSectionStore',
				fieldLabel:getExaminationTranslation('SECTION'),
				valueField: 'id',
				displayField: 'value',
				width: 536,
				disabled:true,
				typeAhead:false,
				hideTrigger:false,
				forceSelection:true,
				cls:'placementProgramMultiselect'
			}]

		},
		{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: '100%',
			defaults: {
				width: 536,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'courseId',
				itemId: 'courseItemId',
				store:'examinationcenters.reports.ExaminationReportCourseStore',
				fieldLabel:getCommonTranslation('COURSE_CODE_NAME'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				minChars:3,
				width: 536,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'evaluationPlanId',
				itemId: 'evaluationPlanItemId',
				store:'examinationcenters.reports.ExaminationReportEPStore',
				fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				minChars:3,
				width: 256,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			}]
		},
		{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: '100%',
			defaults: {
				width: 536,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'studentId',
				itemId: 'studentItemId',
				store:'examinationcenters.reports.ExaminationReportStudentStore',
				fieldLabel:getExaminationTranslation('ADMISSION_CODE_STD_NAME_STD_CODE'),
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'name',
				minChars:3,
				width: 536,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}' +
						'</div>';
					}
				}
			},{
        		xtype: 'customcombobox',
        		width: 256,
				name:'studentStatus',
				itemId:'studentStatus',
				fieldLabel: getCommonTranslation('STATUS'),
				minChars:3,
				typeAhead:false,
				value:true,
				 valueField: 'value',
                 displayField: 'name',
				forceSelection:true,
				store:'common.picklist.StudentActiveInactiveStatusStore',
				disabled:false,
        	}]
		}]
	},
	{
		xtype : 'fieldcontainer',
		width : 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout: 'hbox',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			//buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}
	]
});
