/**
 * @author pradeep.nayak
 */
Ext.define('Academia.view.examinationcenters.reports.examinationdocuments.Examinationdocumentsgrid', {
   // extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport', 
	alias: 'widget.examinationdocumentsgrid', 
    store : 'examinationcenters.examinationdocuments.ExaminationDocumentsStore',
    border: true,
    autoScroll: false,
    frame:false,
    title:getMegaMenuTranslation('SP_EXAMINATION_DOCUMENTS'),   
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
		        xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
	            store : 'examinationcenters.examinationdocuments.ExaminationDocumentsStore',
			    emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			    displayInfo : true
		}]
	}],
	initComponent: function() {

        var grid=this;                   

        grid.addExportToolBarItems(grid);

        this.callParent(arguments);     

	}, tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getExaminationTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getExaminationTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getExaminationTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getExaminationTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
   
    columns: [{
		  	header : getExaminationTranslation('ID'),
		  	dataIndex : 'id',
	        hidden:true,
		  	flex:1,
			renderer: function(value, meta, record) {
				if (record.data.id != undefined) {
					return record.data.id;
				}
			}
		  	
       },{
		  	header :getDocumentTranslation('DOCUMENT_CODE'), 
		  	dataIndex : 'documentCode',
	        hidden:true,
		  	flex:1,
			renderer: function(value, meta, record) {
				if (record.data.documentCode != undefined) {
					return record.data.documentCode;
				}
			}
		  	
       },{
		  	header : getExaminationTranslation('DOCUMENT_NAME'),
		  	dataIndex : 'documentName',
		  	flex:1,
			renderer: function(value, meta, record) {
				if (record.data.documentName != undefined) {
					return record.data.documentName;
				}
			} 
		  	
       },{
            header : getExaminationTranslation('DOCUMENT_UPLOAD_DATE'),
	        dataIndex : 'documentUploadDateTill',
	        flex:1,
			renderer: function(value, meta, record) {
				var dateString=record.data.documentUploadDateTill;
				if (dateString != undefined) {
					var dateObject = Ext.Date.parse(dateString, "Y-m-d");
					var formattedDate = Ext.Date.format(dateObject, "d/m/Y");
					return formattedDate;  
				}
			}
	        
       },{
		  	header : getExaminationTranslation('DOCUMENTS'),
		  	dataIndex : 'documentPath',
		  	flex:1,
			renderer: function(value, meta, record) {
				if (record.data.documentPath != undefined) {
					return "<a href=\'#\'>" + record.data.documentPath + "</a>";
				}
			}
		  	     
       }]
});
