/**
 *  @auther Bhanu Pratap Singh

 */
var PendingMarkNewGridStore=Ext.create('Academia.store.examinationcenters.reports.PendingMarksStore');
Ext.define('Academia.view.examinationcenters.reports.faculty.PendingFacultyMarksGrid', {
	// extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport', 
	alias: 'widget.pendingfacultymarksgrid',
	store: PendingMarkNewGridStore,
	title: getExaminationTranslation('PENDING_MARK_ENTRY'),
	border: true,
	frame:false,
	viewConfig: {
		stripeRows: false
	},
	headerFix: {
		headerFix: true,
		portalIdsWithStructure: {
			'facultypendingmarkentrystructure': 2
		}
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store: PendingMarkNewGridStore,
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar:[
		],
		columns: [{
			header: getCommonTranslation('PROGRAM'),
			dataIndex: 'programName',
			flex:.3,
			sortable: true
		}, {
			header: getCommonTranslation('BATCH'),
			dataIndex: 'batchName',
			flex:.2,
			sortable: true
		},{
			header: getCommonTranslation('PERIOD'),
			dataIndex: 'periodName',
			flex:.2,
			sortable: true
		},{
			header: getCommonTranslation('SECTION'),
			dataIndex: 'sectionName',
			flex:.3,
			sortable: true
		},{
			header: getCommonTranslation('COURSE_CODE'),
			dataIndex: 'courseCode',
			flex:.3,
			sortable: true
		},{
			header: getCommonTranslation('COURSE'),
			dataIndex: 'courseName',
			flex:.4,
			sortable: true
		},{
			header: getCommonTranslation('COURSE_VARIANT'),
			dataIndex: 'courseVariantName',
			flex:.7,
			sortable: true
		},{
			header: getCommonTranslation('DETAILED_SEQUENCE'),
			dataIndex: 'eventName',
			flex:.3,
			sortable: true,
			renderer:function(value,meta,record){
				if(record.data.whetherDynamicScheme){
					return record.data.examEventName;
				}else{
					return value;
				}
			}
		}, {
			header: getCommonTranslation('EVALUATION_PLAN'),
			dataIndex: 'evaluationPlanName',
			flex:.6,
			sortable: true
		},{
			header: getCommonTranslation('FACULTY_NAME'),
			dataIndex: 'facultyName',
			flex:.3,
			sortable: true
		},{
			header: getCommonTranslation('TOTAL_STUDENTS'),
			dataIndex: 'totalStudents',
			flex:.3,
			sortable: true
		},{
			header: getCommonTranslation('MARK_ENTRIES_DONE'),
			dataIndex: 'markEntryDone',
			flex:.3,
			sortable: true,
			renderer:function(value,meta,record){
				if(value==0){
					return value;
				}
				else {
					return '<a href=#>'+value+'</a>'
				}
			}
		},{
			header: getCommonTranslation('SAVED_MARK_ENTRIES'),
			dataIndex: 'savedMarkEntries',
			flex:.3,
			sortable: true,   
			renderer:function(value,meta,record){
				if(value==0){
					return value;
				}
				else {
					return '<a href=#>'+value+'</a>'
				}
			}
		},{
			header:  getCommonTranslation('PENDING_MARK_ENTRIES'),
			dataIndex: 'remainingMarkEntries',
			flex:.3,
			sortable: true,
			renderer:function(value,meta,record){
				if(value==0){
					return value;
				}
				else {
					return '<a href=#>'+value+'</a>'
				}
			}
		},{
			header: getCommonTranslation('ACADEMIC_TERM'),
			dataIndex: 'academicTerm',
			flex:.3,
			hidden:true
		}],
		plugins: [{
			ptype : 'cellediting',
			clicksToEdit: 1
		}]
});
