/**
 * @author Bhanu PS
 */
Ext.define('Academia.view.examinationcenters.revaluation.RevaluationRuleGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.revaluationrulegrid',
	store : 'examinationcenters.revaluation.RevaluationRuleGridStore',
	title : getExaminationTranslation('MANAGE_RULES_LIST'),
	border: true,
	autoScroll: false,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store :  'examinationcenters.revaluation.RevaluationRuleGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {

		var grid=this;                   

		grid.addExportToolBarItems(grid);

		this.callParent(arguments);     

	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype : 'button',
		/*itemId:'spBtnMoreActions',
		text : getCommonTranslation('MOREACTIONS'),*/

		text:getExaminationTranslation('MAP_PROGRAM_DETAIL'),
		itemId:'mapProgramBtn'

	},{
		xtype: 'customcombobox',
		itemId: 'whetherRevalApplicable',
		hidden : true
	}],
	columns: [{
		header : getExaminationTranslation('REVALUATION_TYPE'),
		dataIndex : 'revaluationType',
		flex:1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.revaluationType)) {
				return getExaminationTranslation(""+record.data.revaluationType);
			}                        
		}
	},{
		header : getFeeAndPaymentCommonTranslation('FEE_PLAN_TYPE'),
		dataIndex : 'feePlanType', 
		flex:1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.feePlanType.value)) {
				return record.data.feePlanType.value;
			}                        
		}
	},{
		header : getFeeAndPaymentCommonTranslation('FEE_PLAN_RULE'),
		dataIndex : 'feePlanRule',
		flex:1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.feePlanRule.value)) {
				return record.data.feePlanRule.value;
			}                        
		}
	},{
		header : getExaminationTranslation('NO_OF_REVALUAER'),
		dataIndex : 'noOfRevaluers',
		flex:1
	},{
		header : getExaminationTranslation('MAX_COURSE_TO_APPLY'),
		dataIndex : 'maxRevaluationToApply',
		flex:1
	},{
		header : getExaminationTranslation('RULE_APPLICABLE'),
		dataIndex : 'ruleApplicable',
		flex:1
	},{
		header : getExaminationTranslation('ASSOCIATED_PROGRAMS'),
		dataIndex : 'mappedProgramCount',
		flex:1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.mappedProgramCount) && record.data.mappedProgramCount > 0) {
				 return '<a href=#>'+record.data.mappedProgramCount+'</a>'
			} else {
				return '<sapn style=color:red>Pending</span>';
			}                       
		}
	}]
});