/**
 * @author bhanu ps
 */
Ext.define('Academia.view.examinationcenters.revaluation.RevaluationSetupGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.revaluationsetupgrid',
	store: 'examinationcenters.revaluation.RevaluationGridStore',
	title: getExaminationTranslation('REVALUATION_SETUP'),
	border: true,
	autoScroll: false,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	style: 'margin-bottom: 30px !important;',
	selModel: {
		mode:'SINGLE',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'examinationcenters.revaluation.RevaluationGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype : 'button',
		/*itemId:'spBtnMoreActions',
		text : getCommonTranslation('MOREACTIONS'),*/
	
		text:getExaminationTranslation('MANAGE_RULES'),
		tooltip: getExaminationTranslation('MANAGE_RULES'),
		itemId:'btnManageRule'	
	}],
	columns: [{
		header:  getExaminationTranslation('REVALUATION_CODE_NAME'),
		dataIndex: 'revaluationCode',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return record.data.revaluationCode +" / "+record.data.revaluationName;
			}                        
		}
	},{
		header:getExaminationTranslation('REVALUATION_FEE_APPLICABLE') ,
		dataIndex: 'revaluationFor',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if (!isNullOrEmpty(record.data.whetherRevalFeeApplicable) && record.data.whetherRevalFeeApplicable){
				return getCommonTranslation(""+record.data.revaluationFor);
			}else {
				return (""+"-");
			}
		}
	},{
		header:getExaminationTranslation('MAX_COURSE_TO_APPLY'),
		dataIndex: 'maxRevaluationToApply',
		flex:.1,
		sortable:true
	}]
});
