/**
 * @Author Bhanu PS
 */
Ext.define('Academia.view.examinationcenters.roomallocation.RoomAllocationAddStructure', { 
	extend: 'Ext.form.FormPanel',
	alias : 'widget.roomallocationaddstructure',
	autoScroll: false,
	plugins : "formlabelrequired",
    modal: true,
    autoScroll:false,
    cls:'x-form-fixed-footer-parent',

    frame:true,
    title:getExaminationTranslation('ADD_ROOM_ALLOCATION'),
//	plain: true,
    items : [{
    	xtype:'form',
    	items : [{
    		xtype: 'fieldcontainer',
    		layout: {
    			type: 'hbox'
    		},
    		defaults: {
    			width: 256,
    			labelAlign: 'top'
    		},
    		items:[{
    			xtype: 'customcombobox',
    			name: 'evalGroup',
    			itemId: 'evalGroupId',
    			fieldLabel:getExaminationTranslation('EVALUATION_GROUP'),
    			store:'examinationcenters.examstaffallocation.commonFilter.ExamGroupFilter',
    			valueField: 'id',
      			displayField: 'value',
      			queryParam:'textSearch',
      			minChars:3,
      			width: 536,
      			typeAhead:false,
      			allowBlank:false,
      			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
      			enableKeyEvents  : 'true',
      			hideTrigger:false,
      			forceSelection:true,
      			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
      			listConfig: {
      				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
      				loadingText: getCommonTranslation('SEARCHING'),
      				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
      				getInnerTpl: function() {
      					return '<div class="search-item">' +
      					'{value}' +
      					'</div>';
      				}
      			}  
    		},{
            	xtype: 'customcombobox',
                name: 'evaluationType',
                itemId:'evaluationTypeItemId',
                store:'examCenter.AssignSequence.EvaluationType',
                displayField:'value',
                valueField:'id',
                forceSelection:true,
                editable:false,
	            typeAhead:true,
	            fieldLabel:getExaminationTranslation('EVALUATION_TYPE'),
	            allowBlank: false
            }]
    	},{
    		xtype: 'fieldcontainer',
    		layout: {
    			type: 'hbox'
    		},
    		defaults: {
    			width: 256,
    			labelAlign: 'top'
    		},
    		items:[{
              	xtype: 'customcombobox',
        		name: 'courseId',
        		itemId: 'courseItemId',
        		allowBlank:false,
    			store:'examinationcenters.examstaffallocation.commonFilter.ExamCourseFilter',
    			fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
    			valueField: 'id',
    			displayField: 'value',
    			queryParam:'textSearch',
    			minChars:3,
    			typeAhead:false,
    			disabled:true,
    			width: 536,
    			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
    			enableKeyEvents  : 'true',
    			hideTrigger:false,
    			forceSelection:true,
//    			hidden:true,
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				 },
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				}
    			} 
             },{
            	xtype: 'customcombobox',
                name: 'courseVariant',
                itemId:'courseVariantItemId',
                store:'examinationcenters.examstaffallocation.commonFilter.ExamCVFilter',
                valueField: 'id',
                allowBlank:false,
    			displayField: 'value',
    			fieldLabel:getExaminationTranslation('COURSE_VARIANT'),
    			queryParam:'textSearch',
    			minChars:3,
    			typeAhead:false,
    			disabled:true,
    			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
    			enableKeyEvents  : 'true',
    			hideTrigger:false,
    			forceSelection:true,
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				 },
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				}
    			}
            }]
    	},{
    		xtype: 'fieldcontainer',
    		layout: {
    			type: 'hbox'
    		},
    		defaults: {
    			width: 256,
    			labelAlign: 'top'
    		},
    		items:[{
            	xtype: 'customcombobox',
        		name: 'periodId',
        		itemId: 'periodItemId',
        		allowBlank:false,
    			store:'examinationcenters.examstaffallocation.commonFilter.ExamPeriodFilter',
    			fieldLabel:getExaminationTranslation('PERIOD'),
    			valueField: 'id',
    			displayField: 'value',
    			queryParam:'textSearch',
    			minChars:3,
    			disabled:true,
    			typeAhead:false,
    			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
    			enableKeyEvents  : 'true',
    			hideTrigger:false,
    			forceSelection:true,
//    			hidden:true,
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			listConfig: {
    				listeners: {
  					beforeshow: function(picker) {
  						picker.minWidth = picker.up('combobox').getSize().width;
  					}
  				 },
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				}
    			} 
          },{
            	xtype: 'customcombobox',
                name: 'section',
                itemId:'sectionItemId',
                store:'examinationcenters.examstaffallocation.commonFilter.ExamSectionFilter',
                displayField:'value',
                valueField:'id',
                forceSelection:true,
                disabled:true,
                allowBlank:false,
                editable:false,
	            typeAhead:true,
	            fieldLabel:getExaminationTranslation('SECTION'),
	            allowBlank: false
            },{
            	xtype: 'customcombobox',
                name: 'event',
                itemId:'eventItemId',
                store:'examinationcenters.examstaffallocation.commonFilter.ExamEventFilter',
                displayField:'value',
                valueField:'id',
                forceSelection:true,
                disabled:true,
                editable:false,
	            typeAhead:true,
	            fieldLabel:getExaminationTranslation('DETAILED_SEQUENCE'),
	            allowBlank: false
            }]
    	},{
    		xtype: 'fieldcontainer',
    		layout: {
    			type: 'hbox'
    		},
    		defaults: {
    			width: 256,
    			labelAlign: 'top'
    		},
    		items:[{
    			xtype: 'customcombobox',
    			name: 'centerName',
    			itemId: 'centerNameId',
    			fieldLabel:getExaminationTranslation('CENTER_NAME'),
//    			store:'examinationcenters.examstaffallocation.commonFilter.ExamCenterFilter',
    			valueField: 'id',
      			displayField: 'valueCode',
      			queryParam:'textSearch',
      			minChars:3,
      			typeAhead:false,
      			disabled:true,
      			allowBlank:false,
      			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
      			enableKeyEvents  : 'true',
      			hideTrigger:false,
      			forceSelection:true,
      			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
      			listConfig: {
      				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
      				loadingText: getCommonTranslation('SEARCHING'),
      				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
      				getInnerTpl: function() {
      					return '<div class="search-item">' +
      					'{valueCode}' +
      					'</div>';
      				}
      			},
      			listeners: {
					render : function(combo){
						var store=Ext.create('Academia.store.examinationcenters.examstaffallocation.commonFilter.ExamCenterFilter');
						combo.bindStore(store)
					}
				}
    		},{
    			xtype: 'customcombobox',
    			name: 'examDate',
    			itemId:'examDateItemId',
    			fieldLabel:getExaminationTranslation('DATE'),
    			store:'examinationcenters.examstaffallocation.commonFilter.ExamDateFilter',
    			valueField: 'id',
      			displayField: 'value',
      			queryParam:'textSearch',
      			disabled:true,
      			minChars:3,
      			typeAhead:false,
      			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
      			enableKeyEvents  : 'true',
      			hideTrigger:false,
      			allowBlank:false,
      			forceSelection:true,
      			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
      			listConfig: {
      				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
      				loadingText: getCommonTranslation('SEARCHING'),
      				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
      				getInnerTpl: function() {
      					return '<div class="search-item">' +
      					'{value}' +
      					'</div>';
      				}
      			}
    		},{
    			xtype: 'customcombobox',
    			name: 'timeSlot',
    			itemId: 'timeSlotItemId',
    			fieldLabel:getExaminationTranslation('TIME_SLOT'),
    			store:'examinationcenters.examstaffallocation.commonFilter.ExamBatchFilter',
    			valueField: 'id',
      			displayField: 'value',
      			queryParam:'textSearch',
      			minChars:3,
      			typeAhead:false,
      			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
      			enableKeyEvents  : 'true',
      			hideTrigger:false,
      			disabled:true,
      			allowBlank:false,
      			forceSelection:true,
      			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
      			listConfig: {
      				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
      				loadingText: getCommonTranslation('SEARCHING'),
      				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
      				getInnerTpl: function() {
      					return '<div class="search-item">' +
      					'{value}' +
      					'</div>';
      				}
      			}
    		}]
    	},{
    		xtype: 'fieldcontainer',
    		layout: {
    			type: 'hbox'
    		},
    		defaults: {
    			width: 536,
    			labelAlign: 'top'
    		},
    		items:[{
    			xtype: 'multiselectcombofield',
    			name: 'roomNo',
    			fieldLabel:getExaminationTranslation('ROOM_NO'),
    			store:'examinationcenters.examstaffallocation.commonFilter.FindAllRoomNo',
    			displayField:'valueCode',
    			valueField:'id',
    			disabled:true,
    			allowBlank:false,
    			forceSelection:true,
    			typeAhead:true,
    			cls:'resetPasswordMultiselect'
    		}]
    	},{
    		xtype: 'fieldcontainer',
    		width:'100%',
    		cls:'windowBtnPos',
    		cls:'form-fixed-footer',
    		items:[{
    			xtype: 'button',
    			itemId:'submitBtn',
    			text: getCommonTranslation('SUBMIT'),
    			ui: 'CustomBtnSubmit',
    			scale: CONSTANTS.BUTTONSIZE,
    			formBind:true
    		},{
	            xtype: 'button',
	            text: getCommonTranslation('RESET'),
	            itemId:'resetBtn',
	            ui: 'CustomBtnCancel',
	            scale: CONSTANTS.BUTTONSIZE
	        }]
    	}]
    }]
	});