/**
 * @Author Rajkumar.Patidar
 */
Ext.define('Academia.view.examinationcenters.roomallocation.RoomAllocationStructure', {
    extend: 'Ext.tab.Panel',
    alias: 'widget.roomallocationstructure',
    cls: 'SearchTabPanelWithRightTabs panelNoSpace horizontalScrollingFixed',
    tabbar: {
        cls: 'SearchTabPanelWithRightTabs',
        componentCls: 'searchTabComponent'
    },
    tabPosition: 'top',
    plain: true,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'form',
        title: getCommonTranslation('SEARCH'),
        tabCls: 'right-tab',
        autoScroll: true,
        frame: false,
        defaults: {
            width: '100%'
        },
        items: [{
            xtype: 'form',
            cls: 'customSearchPanel',
            items: [{
                xtype: 'radiogroup',
                itemId: 'roomallocation',
                hidden: true,
                columns: 2,
                vertical: true,
                items: [{
                    boxLabel: getExaminationTranslation('STUDENT_ALLOCATION'),
                    name: 'roomallocation',
                    inputValue: 0,
                    checked: true
                }, {
                    boxLabel: getExaminationTranslation('ROOM_CAPACITY'),
                    name: 'roomallocation',
                    inputValue: 1
                }]
            }, {
                xtype: 'roomallocationquickfilter',
                itemId: 'roomallocationquickfilterId'
            }]
        }, {
            xtype: 'panel',
            style: 'margin-bottom: 10px !important;',
            items: [{
                xtype: 'roomallocationgrid',
                itemId: 'roomAllocationGridId'
                    /*},{
			    		  xtype:'searchresultgrid',
			    		  itemId:'roomCapacityGridId',
			    		  hidden:true*/
            }, {
                xtype: 'searchresultgrid',
                itemId: 'studentAllocationGridForExternalId',
                hidden: true,
                margin: '0 0 0 0'
            }, {
                xtype: 'roomallocationroomcapacitygrid',
                hidden: true,
                margin: '0 0 0 0'
                    /*},{
			    		  xtype:'searchresultgrid',
			    		  itemId:'roomCapacityGridForExternalId',
			    		  hidden:true*/
            }]
        }]
    }]
});