/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.examinationcenters.roomallocation.studentallocation.AllocateRoomsWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.allocateroomswin',
	title:getExaminationTranslation('ALLOCATE_ROOMS'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	maxHeight: 600,
	items: [{
		xtype: 'form',
		itemId:'allocateroomsform',
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype: 'multiselectcombofield',
			name: 'evalGroup',
			itemId: 'evalGroup',
			width: 536,
			fieldLabel:getExaminationTranslation('EVALUATION_GROUP'),
			store:'examinationcenters.roomallocation.EvalGroup',
			displayField:'code',
			valueField:'id',
			forceSelection:true,
			autoloadStore: false,
			typeAhead:true,
			allowBlank:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		},{
			xtype: 'multiselectcombofield',
			name: 'course',
			itemId: 'courseId',
			width: 536,
			fieldLabel: getCommonTranslation('COURSE'),
			store:'examinationcenters.roomallocation.RoomAllocationCourses',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			autoloadStore: false,
			typeAhead:true,
			disabled:true,
			allowBlank:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width:'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				name: 'evalGroupCenterId',
				itemId: 'evalGroupCenterId',
				fieldLabel:getExaminationTranslation('CENTER_NAME'),
				store:'examinationcenters.roomallocation.RoomAllocationCenterByCourses',
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				typeAhead:true,
				disabled:true,
				allowBlank:false
			},{
				xtype: 'customcombobox',
				name: 'evalGroupSchDateId',
				itemId: 'evalGroupSchDateId',
				fieldLabel:getExaminationTranslation('DATE'),
				store:'examinationcenters.roomallocation.RoomAllocationDateByCenter',
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				typeAhead:true,
				disabled:true,
				allowBlank:false
			}]
		},{
			xtype: 'customcombobox',
			name: 'groupScheduleBatchId',
			itemId: 'groupScheduleBatchId',
			fieldLabel: getExaminationTranslation('TIME_SLOT'),
			store:'examinationcenters.roomallocation.RoomAllocationBatchByCenterAndDate',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			typeAhead:true,
			disabled:true,
			allowBlank:false
			
		},{
	        xtype: 'multiselectcombofield',
			name: 'rooms',
			width: 536,
			fieldLabel: getExaminationTranslation('AVAILABLE_ROOMS'),
			store:'examinationcenters.roomallocation.RoomAllocationForRooms',
			displayField:'roomNo',
			valueField:'id',
			forceSelection:true,
			autoloadStore: false,
			typeAhead:true,
			disabled:true,
			allowBlank:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{roomNo}' +
					'</div>';
				}
			}
		},{ 	
			  xtype:'fieldcontainer',
        	  width:'auto',
			  items: [{
			    	 xtype: 'button',
					 action: 'Submit',
					 text: getFeeAndPaymentCommonTranslation('SAVE'),
					 formBind: true,
					 itemId: 'SubmitBtn',
					 ui: 'CustomBtnSubmit',
					 scale: CONSTANTS.BUTTONSIZE
			      },{
					 xtype: 'button',
					 text: getFeeAndPaymentCommonTranslation('CANCEL'),
					 ui: 'CustomBtnCancel',
					 itemId: 'CancelBtn',
					 scale: CONSTANTS.BUTTONSIZE
			      }]
	       }]
		}]	
});