/**
 * Raghavendra.Soni
 **/
Ext.define('Academia.view.examinationcenters.thesisManagement.ThesisManagementSubmitDocumentWindow', {
	extend : 'Ext.window.Window',
	alias: 'widget.thesismanagementsubmitdocumentwindow',
	title : getCommonTranslation('THESIS_DOCUMENT'),
	autoScroll : true,
	width: 600,
	height : 800,
	maxHeight : 900,
	modal : true,
	items : [{
		xtype : 'panel',
		itemId: 'thesisDocumentPanel',
		layout: 'vbox',
		flex: 1,
		width: '100%',
		width: '100%',
		title: getCommonTranslation('THESIS_DOCUMENT'),
		border: true,
		height: 300,
		autoScroll:false,
		autoScroll:false,
		padding:0,
		margin:5,
		items: [{
			xtype : 'panel',
			itemId: 'thesisDocuementPanelMenuView',
			width: '100%',
			padding:0,
			margin:0,
			border: false,
			height: 80,
			autoScroll:false,
			tbar: [
				{
					xtype: 'button',
					itemId: 'btnThesisDocumentAddImage',
					tooltip: getCommonTranslation('ADD'),
					cls: 'CustomBodyBtnSettings'
				},
				{
					xtype: 'button',
					itemId: 'btnThesisDocumentDeleteImage',
					cls: 'CustomBodyBtnReject',
					tooltip: getCommonTranslation('DELETE'),
					disabled: true
				}
				]
		},{
			xtype : 'panel',
			itemId: 'thesisDocumentDVPanel',
			flex: 1,
			width: '100%',
			height: '100%',
			padding:0,
			margin:0,
			autoScroll:true,
			items:[{xtype: 'dataview',
				store: Ext.create('Academia.store.examinationcenters.thesisManagement.ThesisManagementDocumentStore'),
				tpl: new Ext.XTemplate(
						'<tpl for=".">',
						'<tpl if="fileType == &quot;png&quot; || fileType == &quot;jpg&quot; || fileType == &quot;jpeg&quot; || fileType == &quot;gif&quot;">',
						'<div style="margin-bottom: 10px;" class="gallery-thumb-wrap">',
						'<tpl else>',
						'<div style="margin-bottom: 10px;" class="gallery-thumb-wrap" data-qtip="">',
						'</tpl>',
						'<img src="{iconImage}" />',
						'<br/><span>{imageName}</span>',
						'<div><input type="checkbox" value="{documentId}" name="thesisDocumentDataViewImage" onclick="thesisDocumentSelectionChange(\'thesisDocumentDataViewImage\',\'btnThesisDocumentDeleteImage\');" /></div>',
						'</div>',
						'</tpl>'
				),
				multiSelect: true,
				selModel: {
					mode: 'MULTI'
				},
				itemSelector: 'div.gallery-thumb-wrap',
				emptyText: getCommonTranslation('NO_FILES_ADDED_YET_MSG'),
				itemId: 'thesisDocumentDataView',
				cls: 'selectedCls',
				height: '90%',
				deferEmptyText: false,
				style: {
					marginTop: '15px'
				},
				listeners: {

					itemclick: function(dataview, record, item, index, e) {
						// Toggle checkbox state and select/deselect the record
						var checkbox = item.querySelector('input[type=checkbox]');
						if(e.target.type != 'checkbox'){
							if (checkbox) {
								checkbox.checked = !checkbox.checked;
								if (checkbox.checked) {
									thesisDocumentSelectionChange('thesisDocumentDataViewImage','btnThesisDocumentDeleteImage');
									dataview.getSelectionModel().select(record, true);
								} else {
									thesisDocumentSelectionChange('thesisDocumentDataViewImage','btnThesisDocumentDeleteImage');
									dataview.getSelectionModel().deselect(record);
								}
							}
						}
					},
					itemdblclick: function(dataview, record, item, index, e) {
						var extension = record.data.fileType.toLowerCase();
						if (["pdf", "doc", "docx", "xls", "xlsx", "ppt", "pptx", "txt", "odt"].includes(extension)) {
							// me.downloadDocumentFile(record.data.id);
						}
					}
				}
			}]
		}]
	}, {
		xtype : 'panel',
		itemId: 'otherDocumentPanel',
		layout: 'vbox',
		flex: 1,
		width: '100%',
		width: '100%',
		title: getCommonTranslation('OTHER_DOCUMENTS'),
		border: true,
		height: 300,
		autoScroll:false,
		autoScroll:false,
		padding:0,
		margin:5,
		items: [{
			xtype : 'panel',
			itemId: 'otherDocuementPanelMenuView',
			width: '100%',
			padding:0,
			margin:0,
			border: false,
			height: 80,
			autoScroll:false,
			tbar: [
				{
					xtype: 'button',
					itemId: 'btnOtherDocumentAddImage',
					tooltip: getCommonTranslation('ADD'),
					cls: 'CustomBodyBtnSettings'
				},
				{
					xtype: 'button',
					itemId: 'btnOtherDocumentDeleteImage',
					tooltip: getCommonTranslation('DELETE'),
					cls: 'CustomBodyBtnReject',
					disabled: true
				}
				]
		},{
			xtype : 'panel',
			itemId: 'OtherDocumentDVPanel',
			flex: 1,
			width: '100%',
			height: '100%',
			padding:0,
			margin:0,
			autoScroll:true,
			items:[{
				xtype:'dataview',
				store: Ext.create('Academia.store.examinationcenters.thesisManagement.ThesisManagementDocumentStore'),
				tpl: new Ext.XTemplate(
						'<tpl for=".">',
						'<tpl if="fileType == &quot;png&quot; || fileType == &quot;jpg&quot; || fileType == &quot;jpeg&quot; || fileType == &quot;gif&quot;">',
						'<div style="margin-bottom: 10px;" class="gallery-thumb-wrap">',
						'<tpl else>',
						'<div style="margin-bottom: 10px;" class="gallery-thumb-wrap" data-qtip="">',
						'</tpl>',
						'<img src="{iconImage}" />',
						'<br/><span>{imageName}</span>',
						'<div><input type="checkbox" value="{documentId}" name="otherDocumentDataViewImage" onclick="thesisDocumentSelectionChange(\'otherDocumentDataViewImage\',\'btnOtherDocumentDeleteImage\');" /></div>',
						'</div>',
						'</tpl>'
				),
				itemSelector: 'div.gallery-thumb-wrap',
				emptyText: getCommonTranslation('NO_FILES_ADDED_YET_MSG'),
				itemId: 'otherDocumentDataView',
				height: '90%',
				deferEmptyText: false,
				style: {
					marginTop: '15px'
				},
				listeners: {

					itemclick: function(dataview, record, item, index, e) {
						// Toggle checkbox state and select/deselect the record
						var checkbox = item.querySelector('input[type=checkbox]');
						if(e.target.type != 'checkbox'){
							if (checkbox) {
								checkbox.checked = !checkbox.checked;
								if (checkbox.checked) {
									thesisDocumentSelectionChange('otherDocumentDataViewImage','btnOtherDocumentDeleteImage');
									dataview.getSelectionModel().select(record, true);
								} else {
									thesisDocumentSelectionChange('otherDocumentDataViewImage','btnOtherDocumentDeleteImage');
									dataview.getSelectionModel().deselect(record);
								}
							}
						}
					},
					itemdblclick: function(dataview, record, item, index, e) {
						var extension = record.data.fileType.toLowerCase();
						if (["pdf", "doc", "docx", "xls", "xlsx", "ppt", "pptx", "txt", "odt"].includes(extension)) {
							// me.downloadDocumentFile(record.data.id);
						}
					}
				}
			}]
		}]
	},{
		xtype: 'fieldcontainer',
		defaults: {
			labelAlign:'top',
			width: 256
		},
		cls:'fieldContainerClsStage',
		items:[{
			xtype: 'textarea',
			name: 'thesisDocumentRemark',
			itemId: 'thesisDocumentRemark',
			fieldLabel: getCommonTranslation('REMARKS'),
			width: '95%',
			width: '95%',
			height:100,
			maxLength:1000,
		}]}, {
			xtype : 'fieldcontainer',
			cls : 'windowBtnPos',
			items : [{
				xtype : 'button',
				action : 'Submit',
				text : getCommonTranslation('SAVE'),
				itemId : 'thesisDocumentFormSubmitButtonId',
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE,
				disabled : true
			}, {
				xtype : 'button',
				itemId : 'thesisDocumentFormCancelButtonId',
				text : getCommonTranslation('CANCEL'),
				ui : 'CustomBtnCancel',
				scale : CONSTANTS.BUTTONSIZE
			} ]
		} ]
});