/**
 * @author <a href="mailto:ankush.solanki@serosoft.in">Ankush Solanki</a>
 *
 */

Ext.define('Academia.view.examinationdegreeremark.DegreeAuditReportProfileView', {
    extend: 'Ext.form.Panel',
    alias: 'widget.degreeauditreportprofileview',
    autoScroll: false,
	frame: false,
    cls: 'panelNoSpace',
    autoScroll: false,
    items: [{
    	xtype: 'form',
    	cls:'customSearchPanel',
    	plugins: "formlabelrequired",
    	isRemoveToggleButton:true,
        itemId: 'degreeAuditReportSearchForm',
        items:[{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            itemId: 'degreeAuditReportContainer',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
	        items: [ {
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				name : 'programId',
				itemId : 'programId',
				store:Ext.create('Academia.store.student.studentprofile.StudentProgramStore'),
				displayField:'valueCode',
				valueField:'id',
				width: 536,
				queryParam:'programName',
				allowBlank:true,
				minChars:3,
	  			typeAhead:false,
	              emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	              forceSelection:true,
	              listConfig: {
	                  listeners: {
	                  beforeshow: function(picker) {
	                    picker.minWidth = picker.up('combobox').getSize().width;
	                    }
	                  },
	                  loadingText: getCommonTranslation('SEARCHING'),
	                  emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                  getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{code} / {value}'+
	                    '</div>';
	                    }
	                  }
			}, {
				xtype: 'customcombobox',
				name: 'batchId',
				itemId:'batchId',
				fieldLabel : getCourseTxCommonTranslation('BATCH'),
				store: Ext.create('Academia.store.student.studentprofile.StudentProgramStore'),
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				allowBlank:false,
				forceSelection:true,
			}]
        },{
            xtype: 'fieldcontainer',
            width: '100%',
    		cls: 'customSearchPanelBtnsFieldContainerCls',
    		 layout: 'hbox',
            items: [{
                xtype: 'button',
                text: getAdmissionTranslation('SEARCH'),
                itemId: 'degreeAuditReportFindButtonId',
                buttonAlign: 'right',
                formBind: true,
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE
            }, {
                xtype: 'button',
                text: getAdmissionTranslation('CLEAR_SEARCH'),
                itemId: 'degreeAuditReportClearSearch',
                buttonAlign: 'right',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]	
    }, {
    	xtype: 'tabpanel',
    	plain: true,
        border: false,
        autoScroll: false,
        items: [{
        	title: 'Data',
        	xtype: 'panel',
        	cls:'degreeauditreportgridCls',
        	items: [{
        		xtype:'degreeauditreportgrid',
        		itemId:'profileDegreeAuditReportGrid',
        	}]
        },{
        	xtype: 'panel',
        	title: 'Chart',
        	layout: 'vbox',
        	autoScroll: false,
        	style:{overflow:'hidden !important',margin:'0!important'},
        	items:[{
                xtype: 'fieldcontainer',
                layout:{
                	type:'hbox',
                	align:'center'
                }, 
                //style:{'margin': 'auto', 'width': '100%', 'padding': '10px'},
                defaults: {
                    labelAlign: 'top',
                    width: '600',
                },
                width:'100%',
    	        items: [{
                    title: getCommonTranslation('COURSES_STATUS'),
                    frame:true,
                    width: '50%',
                    xtype: 'panel',
                    itemId: 'CourseStatusPanel',
                    items: [{
                            xtype:'fieldcontainer',
                            itemId: 'CourseStatusContainer',
                            items:[{
                                    xtype: 'button',
                                    itemId: 'CourseStatusExtraBtns',
                                    hidden:true,
                                    cls:'CustomToolbarBtnExport',
                                    iconCls:'export-image-icon',
                                    style:{'float':'right'},
                                    menu: []
                            }]
                            },{
                                    xtype: 'degreeauditreportgroupedbarchart',
                                    itemId: 'degreeAuditReportCourseStatusForBarChart',
                                    minWidth: 450,
                                    height: 400,
                                    columnHeight: 30,
                                    columnColor: 'orange',
                                    store: 'Academia.store.examinationdegreeremark.DegreeAuditReportCoursesStatusChartStore',
                                    xAxesNumericField: 'intValue',
                                    yAxesCategoryField: 'name',
                            }]
    	        },{
	            	title: getCommonTranslation('CREDITS_STATUS'),
	                frame:true,
	                xtype: 'panel',
	                width: '50%',
	                itemId: 'creditStatusPanel',
	                items: [{
	                        xtype:'fieldcontainer',
	                        itemId: 'creditsStatusContainer',
	                        items:[{
	                                xtype: 'button',
	                                itemId: 'creditsStatusExtraBtns',
	                                hidden:true,
	                                cls:'CustomToolbarBtnExport',
	                                iconCls:'export-image-icon',
	                                style:{'float':'right'},
	                                menu: []
	                        }]
	                        },{
	                                xtype: 'degreeauditreportgroupedbarchart',
	                                itemId: 'degreeAuditReportCreditsStatusForBarChart',
	                                minWidth: 450,
	                                height: 400,
	                                columnHeight: 30,
	                                columnColor: 'orange',
	                                store: 'Academia.store.examinationdegreeremark.DegreeAuditReportCreditStatusChartStore',
	                                xAxesNumericField: 'doubleValue',
	                                yAxesCategoryField: 'name',
	                        }]
    	        }]
        	},{
                xtype: 'fieldcontainer',
                layout:{
                	type:'hbox',
                	align:'center'
                }, 
                //style:{'margin': 'auto', 'width': '100%', 'padding': '10px'},
                defaults: {
                    labelAlign: 'top',
                    width: '600',
                },
                width:'100%',
	            items: [{
	            	xtype:'tbspacer',
	            	width:'25%'
	            },{
	        		title: getCommonTranslation('CGPA_SCORED'),
	        		frame:true,
	        		width:'50%',
	        		xtype: 'panel',
	        		itemId: 'cgpaStatusPanel',
	        		items: [{
	        			xtype:'fieldcontainer',
	        			itemId: 'cgpaStatusContainer',
	        			items:[{
	        				xtype: 'button',
	        				itemId: 'cgpaStatusExtraBtns',
	        				hidden:true,
	        				cls:'CustomToolbarBtnExport',
	        				iconCls:'export-image-icon',
	        				style:{'float':'right'},
	        				menu: []
	        			}]
	        		},{
	        			xtype: 'degreeauditreportgroupedbarchart',
	        			itemId: 'degreeAuditReportCGPAStatusForBarChart',
	        			minWidth: 450,
	                    height: 300,
	                    columnHeight: 30,
	        			columnColor: 'orange',
	        			store: 'Academia.store.examinationdegreeremark.DegreeAuditReportCGPAStatusChartStore',
	        			xAxesNumericField: 'doubleValue',
	        			yAxesCategoryField: 'name',
	        		}]
	            },{
	            	xtype:'tbspacer',
	            	width:'25%'
	            },]
        	}]
        }]
    }]
});