/**
 * @author Deepak S
 * 
 */
Ext.define('Academia.view.facilitiesresources.managegallery.MyFolderFileGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.myfolderfilegrid',
	border: true,
	margin:'0 0 0 0',
	autoScroll: false,
	emptyText: getCommonTranslation('NORESULTSNMESSAGE'),
	viewConfig: {
		deferEmptyText: false,
		stripeRows: CONSTANTS.STRIPEROWS
	},
	store: 'facilitiesresources.managegallery.ManageGalleryStore',
	selType :'checkboxmodel',
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : true
	},
	/*dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'facilitiesresources.managegallery.ManageGalleryStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],*/
	columns :[{
		header : getPersonModuleTranslation('FILE_NAME'),
		dataIndex : 'imageName',
		flex:2,
		renderer:function(value,meta,record){
			if(value=="link"){
			if(!isNullOrEmpty(value)){
				return '<a href="'+record.data.addHyperlink+'" target="_blank">'+record.data.labelOfHyperlink+'</a>';
			}}
			else
				{
				if(!isNullOrEmpty(value)){
					return '<a href="#">'+value+'</a>';
				}
				}
		}
	},{
		header : getCommonTranslation('UPLOADED_ON'),
		dataIndex : 'uploadedDate',
		flex:2,
		renderer : function(date) {
			if(!isNullOrEmpty(date)){
				var dateVal = dateRender(date);
				var timeVal = timeRender(date);
				var dateTimeVal = dateVal + " at " + timeVal;
				return dateTimeVal;
			}
			else{
				return '';
			}
		}
	},{
		header : getCommonTranslation('SIZE'),
		dataIndex : 'fileSize',
		flex:1,
		hidden:true,
		renderer : function(val) {
			if(!isNullOrEmpty(val)){
				if (val === 0) return '0 KB';

				val = val*1024;
			    var k = 1024;
			    var decimals = 2;
			    var dm = decimals < 0 ? 0 : decimals;
			    var sizes = ['Bytes', 'KB', 'MB'];
			    var i = Math.floor(Math.log(val) / Math.log(k));
			    return parseFloat((val / Math.pow(k, i)).toFixed(dm)) + ' ' + sizes[i];
			    
				/*var sizes = ['KB', 'MB'];
				if (val == 0) return '0 KB';
				var i = parseInt(Math.floor(Math.log(val) / Math.log(1024)));
				return Math.round(val / Math.pow(1024, i), 2) + ' ' + sizes[i];*/
			}
			else{
				return '';
			}
		}
	},{
		header : getCommonTranslation('DOCUMENT_TYPE'),
		dataIndex : 'fileType',
		flex:2,
		hidden:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)){
				value = value.toLowerCase();
				switch(value){
				case 'png':
					return getCommonTranslation('PNG');
					break;
				case 'jpeg':
					return getCommonTranslation('JPEG');
					break;
				case 'gif':
					return getCommonTranslation('GIF');
					break;
				case 'jpg':
					return getCommonTranslation('JPG');
					break;
				case 'docx':
					return getCommonTranslation('DOCX');
					break;
				case 'doc':
					return getCommonTranslation('DOC');
					break;
				case 'odt':
					return getCommonTranslation('ODT');
					break;
				case 'pdf':
					return getCommonTranslation('PDF');
					break;
				case 'xlsx':
					return getCommonTranslation('XLSX');
					break;
				case 'xls':
					return getCommonTranslation('XLS');
					break;
				case 'ppt':
					return getCommonTranslation('PPT');
					break;
				case 'pptx':
					return getCommonTranslation('PPT');
					break;	
				case 'txt':
					return getCommonTranslation('TXT');
					break;
				}
				
			}
		}
	}]
});
