/**
 *  @author Priyanshi Sharma
 */
Ext.define('Academia.view.facilitiesresources.resourcebooking.MarkEventAttendanceGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.markeventattendancegrid',
	store :'facilitiesresources.resourcebooking.MarkEventAttendanceStore',
	title: getCommonTranslation('EVENT_NAME'),
	border: true,
	//selType:'checkboxmodel',
	autoScroll: false,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	/*dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'facilitiesresources.resourcebooking.MarkEventAttendanceStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],*/
	initComponent: function() {

		var grid=this;                   

		grid.addExportToolBarItems(grid);

		this.callParent(arguments);     

	},
	tbar: [{
		xtype : 'radiogroup',
		itemId:'markAttendanceRadioId',
		 defaults: {
    		 flex: 1
    	 },
		items : [{
				xtype: 'button',
				text: getCommonTranslation('SAVE'),
				itemId: 'submitBtn',
				style:{'margin':'0px 15px 0px 0px !important'},
				ui : 'CustomBtnCancel',
				formBind:true,
				disabled : true,
				scale: CONSTANTS.BUTTONSIZE,
				cls: 'btn-with-no-icon'
		},{
			fieldLabel: getCommonTranslation('USER_TYPE'),
            xtype: 'customcombobox',
            name: 'userTypeEventAttend',
            itemId: 'userTypeEventAttend',
            store: 'facilitiesresources.resourcebooking.MarkEventAttendanceUserTypeStore',
            valueField: 'value',
            displayField: 'name',
            labelWidth:80,
            editable: false,
            triggerAction: 'all',
            forceSelection: true
		},{
			fieldLabel: getCommonTranslation('DATE')+ '<span class="required" style="color:red"> *</span>',
			xtype: 'datefield',
			width: 256,
			allowBlank:false,
			labelWidth:45,
			name : 'fromDate',
			itemId: 'EventAttendanceDate',
			 style:{
					marginLeft:'11px'
				},
	},{
			boxLabel : getHostelTranslation('MARK_ALL_PRESENT'),
			name : 'markAttendance',
			inputValue : 'PRESENT',
			cls:'markPresentAttendanceCls'
		},{
			boxLabel : getHostelTranslation('MARK_ALL_ABSENT'),
			name : 'markAttendance',
			inputValue : 'ABSENT',
			cls:'markAbsentAttendanceCls'
		}]
	}],
	columns: [{
		header : getCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentCode',
		hidden:true,
		flex:1,
	},{
		header : getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		hidden:true,
		flex:1,
	},{
		header : getCommonTranslation('USERID'),
		dataIndex : 'userCode',
		flex:1,
	},{
		header : getHostelTranslation('NAME'),
		dataIndex : 'userName',
		flex:1
	},	{
		header : getCommonTranslation('DEPARTMENT'),
		dataIndex : 'deptName',
		flex:1,
	},{ 
		xtype : 'checkcolumn', 
		 flex:1,
		 itemId:'presentId',
		 text : getProgramandcourseTranslation('PRESENT'), 
		 dataIndex : 'present'
	 },{
		xtype : 'checkcolumn',
		 text : getCommonTranslation('ABSENT'),
		 dataIndex :  'absent',
		flex:1
	}],
	 plugins: [{
		 ptype : 'cellediting',
		 clicksToEdit: 1,
		 listeners: {
			 edit: function(obj, editor, context){
				 var this$= this;
				 var grid = obj.grid;
				 var store = grid.getStore();
				 var models = grid.getStore().getRange();
				 for(var i =0; i<store.data.length;i++){
					 if(editor.rowIdx==i){
						 models[i].set('present', false);
						 models[i].set('absent', false);
					 }
				 }
			 }
		 }
	 }]
});