/**
 * @author Niklesh
 * 
 * This component is used for to show list of Alumni in grid
 */
Ext.define('Academia.view.facilitiesresources.resourcebooking.ResourceBookingAlumniGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.resourcebookingalumnigrid',
    border: true,
    selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : false,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
    multiSelect: true,
    viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	cls:'disabledOpacity centerAlignTitle',
//    dockedItems: [{
//        xtype: 'toolbar',
//        dock: 'bottom',
//        items: [{
//            xtype: 'custompagingtoolbar',
//            plugins: ['pagesize'],
//            //store: 'alumni.alumniList.AlumniListStore',
//            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
//            displayInfo: true,
//            isGridConfigurable: true, //**
//    	    enableColumnHide: false,
//        }]
//    }],
    columns: [{
        header: getAlumni('ALUMNI_ID'), //Alumni ID
        dataIndex: 'alumniCode',
        flex: .2
    },{
        header: getAlumni('NAME'), //Alumni Name
        dataIndex: 'alumniName',
        flex: .2,
    },
    {
        header: getAlumni('ACADEMY_LOCATION'), //Alumni AcademyLocationName
        dataIndex: 'academyLocationName',
        flex: .2
    }, 
    {
        header: getAlumni('PROGRAM'), //Alumni Program
        dataIndex: 'programName',
        flex: .2
    },
    {
        header: getAlumni('BATCH'), //Alumni Batch
        dataIndex: 'batchName',
        flex: .2
    }],
    initComponent: function() {
    	var this$ = this;
        Ext.apply(this$, {
//    		dockedItems: [{
//    			xtype: 'toolbar',
//    			dock: 'bottom',
//    			items: [{
//    				xtype: 'custompagingtoolbar',
//    				plugins: ['pagesize'],
//    				store: store,
//    				emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
//    				displayInfo: true
//    			}]
//    		}],
        	store: Ext.create('Academia.store.facilitiesresources.resourcebooking.AlumniResourceListStore'),
            tbar: [{
                xtype: 'textfield',
                fieldLabel: getAlumni('ALUMNI_NAME'),
                itemId: 'txtName',
                width: '40%',
                emptyText: getCommonTranslation('PLACE_HOLDER_EMPTY_TEXT'), //Alumni Name
                labelAlign: "top",
            }, {
                xtype: 'customcombobox',
                fieldLabel: getAlumni('ACADEMY_LOCATION'),
                itemId: 'cmbAcademyLocation',
                store: 'facilitiesresources.resourcebooking.AlumniAcademyLocationListByUserStore',
                valueField: 'id',
                displayField: 'value',
                value:'',
                width: '30%',
        		matchFieldWidth : false,
        		listConfig : {
        			width:260
        		},
                editable: false,
                queryMode: 'local',
                triggerAcation: 'all',
                fourceSelection: true,
                autoScroll:false,
                labelAlign: "top",
                listConfig: {
					listeners: {
	                    beforeshow: function (picker) {
	                        picker.minWidth = picker.up('combobox').getSize().width;
	                        picker.maxWidth = picker.up('combobox').getSize().width;
	                    }
	                },
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
            }, {
                xtype: 'customcombobox',
                fieldLabel: getAlumni('PROGRAM_NAME'),
                itemId: 'cmbAlumniProgram',
                store: 'facilitiesresources.resourcebooking.AlumniAllProgramsStore',
                valueField: 'id',
                displayField: 'value',
                value:'',
                width: '30%',
        		matchFieldWidth : false,
        		listConfig : {
        			width:260
        		},
                editable: false,
                queryMode: 'local',
                triggerAcation: 'all',
                fourceSelection: true,
                labelAlign: "top",
            }]
        });
        this$.callParent(arguments);
    },
});