Ext.define('Academia.view.facilitiesresources.resourcebooking.ResourceBookingFormFacilityTree', {
    extend: 'Ext.tree.Panel',
    alias: 'widget.resourcebookingfacilitytree',
    title: getCommonTranslation('FACILITIES_STRUCTURE'), //Facilities Structure 
    border: true,
    cls: 'no-tree-icon',
    rootVisible: true,
    multiSelect: true,
    singleExpand: false,
    initComponent: function() {
        Ext.apply(this, {
            store: Ext.create('Academia.store.facilitiesresources.resourcebooking.ResourceBookingFormFacilitiesTreeStore')            
        }); 
        this.callParent(arguments);
    },
    collapse : function (record, deep, callback, scope) {
        this.callParent(arguments);
        this.refresh();
    },
    expand : function (record, deep, callback, scope) {
        this.callParent(arguments);
        this.refresh();
    }  ,
  /*  listeners: {
        
        'checkchange': function( node, checked ) {
            alert( 'Check / Uncheck' );
        },
        
        'click': function( node, event ) {
            alert( 'Click' );
        },
        
        'expand': function( node ) {
            alert( 'Expand' );
        },
        
        'collapse': function( node ) {
            alert( 'Collapse' );
        }
        
    },*/
    columns: [{
        xtype: 'treecolumn',
        text: getCommonTranslation('FACILITY'), //Facility
        flex: 2,
        dataIndex: 'text'
    }, {
        text: getCommonTranslation('STATUS'), //Status
        flex: 1,
        dataIndex: 'model',
        hidden:true,
        renderer: function(object) {
        	var status= comboRender(object, 'availabilityStatus');    
        	if(status ==='AVAILABLE'){
            	return '<div style="color:green;">('+getCommonTranslation('AVAILABLE')+')</div>';
            }else if(status==='BOOKED'){
            	return '<div style="color:red;">('+getCommonTranslation('BOOKED')+')</div>';
            }else if(status==='PARTLY_AVAILABLE'){
            	return '<div style="color:orangered;">('+getCommonTranslation('PARTLY_AVAILABLE')+')</div>';
            }         	            
        }
    }, {
        text: getCommonTranslation('AVAILABLE_CAPACITY'), //Available Capacity
        flex: 1,
        dataIndex: 'model',
        renderer: function(object) {
        	return comboRender(object, 'capacity');
        }
    }],

    tbar: [{
        xtype: 'customcombobox',
        itemId: 'cmbResourceGroup',
        store: 'facilitiesresources.resourcebooking.ResourceGroupStore',
        //			fieldLabel:getCommonTranslation('RESOURCE_GROUP'),//Resource Group
        labelWidth: '30%',
        valueField: 'name',
        width:'20%',
        displayField: 'value',
        editable: false,
        value: '',
        queryMode: 'local',
        triggerAcation: 'all',
        fourceSelection: true
    }, {
        xtype: 'customcombobox',
        itemId: 'cmbResourceType',
        //store: 'facilitiesresources.resourcebooking.ResourceTypeStore',
        //			fieldLabel:getCommonTranslation('RESOURCE_TYPE'),//Resource Type
        labelWidth: '30%',
        width:'20%',
        valueField: 'id',
        displayField: 'value',
        editable: false,
        value:'',
        queryMode: 'local',
        triggerAcation: 'all',
        fourceSelection: true,
        listeners: {
            render: function(combo) {
                var store = Ext.create('Academia.store.facilitiesresources.resourcebooking.ResourceTypeStore');
                combo.bindStore(store);
            }
        }
    },{
	    xtype: 'button',
	    tooltip: getCommonTranslation('VIEW_CALENDAR'), //View Calendar  
	    itemId: 'btnViewCalendar',
	    text:getCommonTranslation('VIEW_CALENDAR') //View Calendar
	}]
});