/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show list of faculties in grid
 */
Ext.define('Academia.view.facilitiesresources.resourcebooking.ResourceBookingFormFacultyGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.resourcebookingfacultygrid',
    border: true,
    multiSelect: true,
    columns: [{
        header: getCommonTranslation('FACULTY_ID'), //Faculty ID
        dataIndex: 'facultyCode',
        flex: .2
    }, {
        header: getCommonTranslation('FACULTY_NAME'), //Faculty Name
        dataIndex: 'name',
        flex: .3
    }, {
        header: getCommonTranslation('DEPARTMENT'), //Department
        dataIndex: 'department',
        flex: .2,
        renderer: function(object) {
            return columnObjRender(object, 'value');
        }
    }, {
        header: getCommonTranslation('SUBDEPARTMENT'), //Sub department
        dataIndex: 'subDepartment',
        flex: .2,
        renderer: function(object) {
            return columnObjRender(object, 'value');
        }
    }, {
        header: getCommonTranslation('STATUS'), //status
        dataIndex: 'isBooked',
        flex: .2,
        hidden:true,
        renderer:function(value){
        	if(value==true){
        		return '<div style="color:red;">('+getCommonTranslation('BOOKED')+')</div>';
        	}else{
        		return '<div style="color:green;">('+getCommonTranslation('AVAILABLE')+')</div>';
        	}        	
        }
    }],
    initComponent: function() {
    	var this$ = this;
        Ext.apply(this$, {
            store: Ext.create('Academia.store.facilitiesresources.resourcebooking.FacultyListStore'),
            viewConfig: {
                stripeRows: CONSTANTS.STRIPEROWS,
                plugins: {
                    ptype: 'gridviewdragdrop'
                },
                loadMask: false,
                listeners: {
                    drop: function(node, data, dropRec, dropPosition) {
                    	var currGrid,targetGrid,countOfTargetGrid,countOfCurrGrid,me=this;
                    	if(data && data.view){
                    		currGrid = data.view.ownerCt;
                    	}
                        targetGrid = me.ownerCt;
                        if(targetGrid && targetGrid.getStore()){
                        	countOfTargetGrid = targetGrid.getStore().getCount(); 
                        }
                        if(currGrid && currGrid.getStore()){
                        	countOfCurrGrid = currGrid.getStore().getCount(); 
                        }
                        if( targetGrid.down('#totalRecordDisplayField')){
                        	 targetGrid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ countOfTargetGrid);
                        }
                        if(currGrid.down('#totalRecordDisplayField')){
                        	currGrid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ countOfCurrGrid)
                        }
                    }
                }
            },
            tbar: [{
                xtype: 'textfield',
                itemId: 'txtName',
                hidden: (this$.selectedFacultyGrid)?true:false,
                width: '15%',
                emptyText: getCommonTranslation('PLACE_HOLDER_EMPTY_TEXT') //Faculty Name
            }, {
                xtype: 'customcombobox',
                itemId: 'cmbDepartment',
                hidden: (this$.selectedFacultyGrid)?true:false,
                store: 'facilitiesresources.resourcebooking.departmentFilterStore',
                valueField: 'id',
                displayField: 'name',        
                width: '15%',
        		matchFieldWidth : false,
        		listConfig : {
        			width:250
        		},
                value:'',
                editable: false,
                queryMode: 'local',
                triggerAcation: 'all',
                fourceSelection: true
            }, {
                xtype: 'customcombobox',
                itemId: 'cmbSubDepartment',
                hidden: (this$.selectedFacultyGrid)?true:false,
                store: 'facilitiesresources.resourcebooking.subdepartmentFilterStore',
                valueField: 'id',
                displayField: 'name',        
                width: '15%',
        		matchFieldWidth : false,
        		listConfig : {
        			width:250
        		},
                value:'',
                editable: false,
                queryMode: 'local',
                triggerAcation: 'all',
                fourceSelection: true
            },{
        	    xtype: 'button',
        	    tooltip: getCommonTranslation('VIEW_CALENDAR'), //View Calendar  
        	    itemId: 'btnViewCalendar',
        	    text:getCommonTranslation('VIEW_CALENDAR') //View Calendar
        	}]
        });
        this$.callParent(arguments);
    },
	/*dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            emptyMsg: getCommonTranslation('EMPTY_FACULTY_MESSAGE'),
            displayInfo: true
        }]
    }],*/
    listeners: {
        viewready: function(grid) {
            var view = grid.view;

            grid.tip = Ext.create('Ext.tip.ToolTip', {
                target: view.el,
                delegate: '.x-grid-cell',
                trackMouse: true,
                renderTo: Ext.getBody(),
                listeners: {
                    beforeshow: function updateTipBody(tip) {
                        tip.update(getCommonTranslation('SELECT_RECORD_FOR_DRAG_DROP')); //Please select a record for drag and drop
                    }
                }
            });

        }
    }
});