/*
 *@author prathamesh.sheth
 * 
 * This Component is used for to show Resource Booking form details. 
 */
Ext.define('Academia.view.facilitiesresources.resourcebooking.ResourceBookingFormLayout', {
    extend: 'Academia.view.common.IdGeneratorForm',
    alias: 'widget.resourcebookingformlayout',
    cls: 'x-form-fixed-footer-parent',
    formCode:'ResourceBookingFormLayout',
    //autoScroll: true,
    frame: true,
    style:{
    	marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
    },
   /* requires : ['Academia.view.facilitiesresources.resourcebooking.ResourceBookingFormFacilityTree', 
               'Academia.view.facilitiesresources.resourcebooking.ResourceBookingFormFacilitySelectedPanel', 
               'Academia.view.facilitiesresources.resourcebooking.ResourceBookingFormEquipmentGrid', 
               'Academia.view.facilitiesresources.resourcebooking.ResourceBookingFormExternalResourceGrid', 
               'Academia.view.facilitiesresources.resourcebooking.ResourceBookingFormAdhocResourceGrid', 
               'Academia.view.facilitiesresources.resourcebooking.ResourceBookingFormFacultyGrid', 
               'Academia.view.facilitiesresources.resourcebooking.ResourceBookingFormUserGrid', 
               'Academia.view.facilitiesresources.resourcebooking.ResourceBookingFormProgramGrid', 
               'Academia.view.facilitiesresources.resourcebooking.ResourceBookingFormCourseGrid', 
               'Academia.view.facilitiesresources.resourcebooking.ResourceBookingFormAcademyLocationGrid' ], */	
    itemId: 'resourcebookingform',
    title: getCommonTranslation('ADD_NEW_EVENT_DETAILS'), //Add New Event Details
    plugins: "formlabelrequired",
    method: 'POST',    
    standardSubmit: false,
    minWidth:800,
        items: [{
            layout: {
                type: 'hbox'
            },
            width: 850,
            items: [{
                flex: .2,
                defaults: {
                	width: 256,
                    labelAlign: 'top'
                },
                items: [{
                    xtype: 'hidden',
                    itemId: 'versionId_hidden_field',
                    name: 'version'
                },{
                    xtype: 'hidden',
                    itemId: 'eventCalendarId',
                    name: 'eventCalendarId'
                },{       
                	xtype: 'hidden',
                    itemId: 'ID',
                    name: 'id'
                }, {
                    xtype: 'textfield',
                    name: 'resourceCategoryCode',
                    itemId: 'resourceCategoryCode',
                    fieldLabel: getCommonTranslation('EVENT_ID'), //Booking ID
                    emptyText: getCommonTranslation('ID_AUTOGENERATE'),
                    maxLength: 10
                    //allowBlank: false		
                },{
                    xtype: 'textfield',
                    name: 'eventName',
                    fieldLabel: getCommonTranslation('EVENT_NAME'), //Event Name
                    allowBlank: false,
                    maxLength: 255
                },{
                    xtype: 'textfield',
                    name: 'conductedBy',
                    itemId: 'cmbconductedBy',
                    fieldLabel: getCommonTranslation('CONDUCTED_BY'), //Booked By
                    visible:false,
                    hidden:true,
                    allowBlank: false
                }, {
                    xtype: 'datefield',
                    name: 'eventDate',
                    itemId: 'eventDate',
                    vtype: 'daterange',
                    endDateField: 'toDate',
                    fieldLabel: getCommonTranslation('EVENT_DATE'), //Event Date
                    editable: false,
                    //minValue: new Date(),
                    //value:new Date(),
                  //--submitFormat: CONSTANTS.DATE_FORMAT,
                    listeners: {
                    	render: function(obj) {
    						obj = dateFormatRender(obj);						
    						obj.setValue(new Date());
    					}
                    },
                    allowBlank: false
                }, {
                    xtype: 'numberfield',
                    name: 'noOfParticipants',
                    itemId:'numOfParticipants',
                    fieldLabel: getCommonTranslation('PARTICIPANTS'), //NO. Of Participants
                    maxLength: 5,
                    minValue:0,
                    value:0,
                    allowBlank: false,
                    validator: function(value){
                    	var validText = getCommonTranslation('ENTER_ONLY_INTEGER_NUMBER');
                    	var patt = new RegExp('^[0-9]+$');
                    	var res = patt.test(value);
                        if(res) {
                            return true;
                        } else {
                            return validText;
                        }
                    }
                },{
                    xtype: 'textareafield',
                    name: 'eventDesc',
                    fieldLabel: getCommonTranslation('EVENT_DESC'), //Event Description
                    maxLength: 255,
                    //flex: .2,
                    allowBlank: false
            	 }]
            }, {
                flex: .2,
                defaults: {
                    width: 256,
                    labelAlign: 'top'
                },
                items: [{
                    xtype: 'customcombobox',
                    name: 'bookingPurpose',
                    itemId: 'cmbBookingPurpose',
                    fieldLabel: getCommonTranslation('EVENT_PURPOSE'), //Event Purpose
                    store: 'facilitiesresources.resourcebooking.ResourceBookingPurposeStore',
                    valueField: 'id',
                    displayField: 'value',
                    editable: false,
                    queryMode: 'local',
                    triggerAction: 'all',
                    forceSelection: true,
                    allowBlank: false,
                    style:{
                    	marginTop:'2px'
                    }
                }, 
                {
					xtype : 'fieldcontainer',
					layout : 'hbox',
					defaults : {
						width: 256,
						labelAlign : 'top'
					},
					items : [{
	                    xtype: 'checkboxfield',
	                    boxLabel: getCommonTranslation('COMPLETE_DAY'), //Complete Day
	                    name: 'isCompleteDay',
	                    checked: true,
	                    inputValue: 'true',
	                    uncheckedValue: 'false',
	                    itemId: 'chkCompleteDay',
	                    style:{
	                    	marginTop:'26px'
	                    }
	                }, {
	                    xtype: 'checkboxfield',
	                    boxLabel: getCommonTranslation('RECURRING'), //Recurring
	                    name: 'isRecurring',
	                    inputValue: 'true',
	                    uncheckedValue: 'false',
	                    itemId: 'chkRecurring',
	                    style:{
	                    	marginTop:'26px',
	                    	marginRight:'0px !important'
	                    }
	                }]
                },
                {
                    xtype: 'datefield',
                    name: 'toDate',
                    itemId: 'toDate',
                    vtype: 'daterange',
                    //minValue: new Date(),
                    startDateField: 'eventDate',
                    fieldLabel: getCommonTranslation('TO_DATE'), //To Date
                    editable: false,
                  //--submitFormat: CONSTANTS.DATE_FORMAT,
                    listeners: {
                    	render: function(field) {
                    		return dateFormatRender(field);
                    	}
                    },
                    disabled:true,
                    allowBlank: false
                }, {
                    xtype: 'textfield',
                    name: 'venue',
                    fieldLabel: getServiceRequestTranslation('VENUE'),
                    //maxLength: 250,
                    allowBlank: true,
                    maxLength: 45
                },{
            	xtype: 'textareafield',
            	name: 'purposeDesc',
            	fieldLabel: getCommonTranslation('PURPOSE_DETAIL'), //Purpose Detail
            	maxLength: 255,
            	width: 256,
            }
			]
            }, {
                flex: .2,
                defaults: {
                    width: 256,
                    labelAlign: 'top'
                },
                items: [{
        			xtype: 'customcombobox',
        			name: 'committee',
        			itemId:'committeeItemId',
        			store:'committee.committee.CommitteeStore',
        			displayField:'valueCode',
        			valueField:'id',
        			queryParam:'name',
        			hidden:true,
        			allowBlank:false,
        			typeAhead:false,
        			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
        			enableKeyEvents  : 'true',
        			hideTrigger:false,
        			minChars:3,
        			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        			triggerAction: '',
        			forceSelection:true,
        			listConfig: {
        				listeners: {
        					beforeshow: function(picker) {
        						picker.minWidth = picker.up('combobox').getSize().width;
        					}
        				},
        				loadingText: getCommonTranslation('SEARCHING'),
        				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        				getInnerTpl: function() {
        					return '<div class="search-item">' +
        					'{value}' +
        					'</div>';
        				}
        			},
        			fieldLabel:getCommonTranslation("COMMITTEE_CODE_NAME")
        		},{
                    xtype: 'customcombobox',
                    name: 'bookedBy',
                    itemId: 'cmbBookedBy',
                    fieldLabel: getCommonTranslation('BOOKED_BY'), //Booked By
                    store: 'common.ActiveUserStore',
                    valueField: 'id',
                    displayField: 'valueCode',
                    allowBlank: false,
                    queryParam:'name',
    				minChars:3,
    				typeAhead:false,
    				forceSelection:true,
    				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
    				//triggerAction: '',
    				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    	            maxLength: 100,
    				listConfig: {
    					listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
    						}
    					},
    					loadingText: getCommonTranslation('SEARCHING'),
    					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    					getInnerTpl: function() {
    						return '<div class="search-item">' +
    						'{value}' +
    						'</div>';
    					}
    				}
        	        
                }/*{
                    xtype: 'textfield',
                    name: 'eventName',
                    fieldLabel: getCommonTranslation('EVENT_NAME'), //Event Name
                    allowBlank: false
                }*/,{
                    xtype: 'multiselectcombofield',
                    name: 'repeatOn',
                    itemId: 'repeatOnItemId',
                    fieldLabel: getServiceRequestTranslation('EVENT_REPEAT_ON'),
                    //autoloadStore: false,
                    store: 'transport.serviceRoute.WeekDays',
                    cls:'multiBrandCampusCls',
                    displayField: 'value',
                    valueField: 'id',
                    allowBlank: true,
                    hidden:true,
                    minChars: 3,
                    typeAhead: true,
                    triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
                    enableKeyEvents: 'true',
                    hideTrigger: false,
                    forceSelection: true,
                    listConfig: {
                        listeners: {
                            beforeshow: function(picker) {
                                picker.minWidth = picker.up('combobox').getSize().width;
                            }
                        },
                        loadingText: getCommonTranslation('SEARCHING'),
                        emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                        getInnerTpl: function() {
                            return '<div class="search-item">' +
                                '{code}' +
                                '</div>';
                        }
                    }
                },{
					xtype : 'fieldcontainer',
//					width: 'auto',
					layout : 'hbox',
					cls:'resourceBookingTimeContainerCls',
					defaults : {
						labelAlign : 'top'
					},
					items : [{
                    xtype: 'timefield',
                    name: 'timeFrom',
                    itemId: 'timeFrom',
                    fieldLabel: getCommonTranslation('TIME_FROM'), //Time From
                    submitFormat: CONSTANTS.DISPLAY_TIME_FORMAT,
                    increment: 30,
                    width:105,
                    disabled: true,
                    vtype: 'timerange',
                    endTimeField: 'timeTo',
                    allowBlank: false,
    				listeners: {
    					render: function(field) {
    						return timeFormatRender(field);
    					}
    				}
                }, {
                    xtype: 'timefield',
                    name: 'timeTo',
                    itemId: 'timeTo',
                    fieldLabel: getCommonTranslation('TIME_TO'), //Time To
                    submitFormat: CONSTANTS.DISPLAY_TIME_FORMAT, //Select to time
                    increment: 30,
                    width:105,
                    disabled: true,
                    vtype: 'timerange',
                    startTimeField: 'timeFrom',
                    allowBlank: false,
    				listeners: {
    					render: function(field) {
    						return timeFormatRender(field);
    					}
    				}		
                }]
				},{
                    xtype: 'checkboxfield',
                    boxLabel: getCommonTranslation('MANDATORY_EVENT'), //This event is mandatory
                    name: 'isMendatory',
                    inputValue: 'true',
                    uncheckedValue: 'false',
                    itemId: 'isMandatoryEvent',
                    style:{
                    	marginTop:'32px'
                    }
                },{
                    xtype: 'numberfield',
                    name: 'eventBudget',
                    itemId:'eventBudget',
                    fieldLabel: getServiceRequestTranslation('EVENT_BUDGET'),
                    maxLength: 6,
                    minValue:0,
                    value:0,
                    allowBlank: true,
                    validator: function(value){
                    	var validText = getCommonTranslation('ENTER_ONLY_INTEGER_NUMBER');
                    	var patt = new RegExp('^[0-9]+$');
                    	var res = patt.test(value);
                        if(res) {
                            return true;
                        } else {
                            return validText;
                        }
                    }
                }]
            }]
        },{
          	 xtype: 'fieldcontainer',
        	 layout : 'hbox',
        	 style:{
             	marginTop: '-70px',
             	marginLeft: '20px'
             },
        	 defaults: {
                 width: 256,
                 labelAlign: 'top'
             },
        	 items: [/*{
                xtype: 'textareafield',
                name: 'eventDesc',
                fieldLabel: getCommonTranslation('EVENT_DESC'), //Event Description
                maxLength: 255,
                //flex: .2,
                allowBlank: false
        	 },{ 
        		 xtype: 'tbspacer', 
        		 width: 50 
        	 },{
            	xtype: 'textareafield',
            	name: 'purposeDesc',
            	fieldLabel: getCommonTranslation('PURPOSE_DETAIL'), //Purpose Detail
            	maxLength: 255
            }*/]
        },{
        	xtype: 'fieldcontainer',
        	style:{
        		marginTop: '60px'
        	},
        	defaults: {
        		width: 256,
        		labelAlign: 'top'
        	},
        	items: [{
        		xtype:'meetingdocumentgrid',
        		itemId:'documentsGridResourceBooking',
        		//hidden:true,
        		minHeight: 0,
        		cls: 'no-empty-placeholder-grid',
        		isFixHeightGrid: true,
        		isFixWidthColums: true,
        		style:{
        			marginLeft:'0px !important'
        		}
        	},{
        		xtype: 'button',
        		name: 'meetingDocs',
        		//hidden:true,
        		text:getCommonTranslation('UPLOAD_DOC'),
        		itemId: 'meetingDocsId',
        		ui: 'CustomBtnThird',
        		cls:'btn-with-no-icon',
        		scale : CONSTANTS.BUTTONSIZE
        	}]
        }, {
            xtype: 'fieldcontainer',
            style:{
            	marginTop: '0px',
            	marginBottom: '10px'
            },
            defaults: {
                width: 536,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'label',
                width: 150,
                html: "<span style='font-weight: bold;'>" + getServiceRequestTranslation('EVENT_BANNER') + ":</span>",
                style: {
                	marginBottom: '10px',
                	display:'inline-block'
                }
            },{
            	html: '<i>'+getCommonTranslation('PLEASE_PREFER_IMAGE_SIZE')+'</i>',
            	margin: 0,
            },{
            	xtype: 'photouploadform',
            	itemId: 'eventBannerItemId'
            }, {
            	xtype:'image',
                itemId: 'eventBannerBgImage',
                border: 1,
                style: {
                    borderColor: 'black',
                    borderStyle: 'solid'
                },
                width: 222,
                height: 150,
                src:'resources/images/Event_Banner.png'
            },{
            	xtype:'hidden',
            	itemId: 'eventBannerURLItemId',
            	name: 'eventBannerURL'
            }]
        }, {
            xtype: 'tabpanel',
            itemId: 'resourceBookingTabPanel',
            cls:'resourceBookingTabPanelCls',
            minWidth:800,
            plain: true,
            height: 560,
            style:{
            	marginTop: '10px',
            	marginLeft:'0px !important'
            },
            activeTab: 0,
            items: [
            	
            	 {                	
                     title: getCommonTranslation('ACADEMY_LOCATION_TABTILE'), //Academy-Locations
                     itemId:'academyLocationPanel',
                     margin: 0,
                     closable: false,
                     items: [{
                         xtype: 'resourcebookingacadlocgrid',
                         itemId: 'academyLocationListGrid',                        
                         height: 500
                     }]
                 },{                	
                     title: getCommonTranslation('USER_TABTITLE'), //Users
                     closable: false,
                     itemId:'userTabPanel',
                     margin: 0,
                     layout: {
                         type: 'hbox'
                     },
                     items: [{
                         xtype: 'resourcebookingusergrid',
                         itemId: 'userListGrid',
                         selectedUserGrid: false,
                         title: getCommonTranslation('USERS_AVAILABLE'), // Users Available
                         cls:'centerAlignTitle',
                         height: 500,
                         flex: .5
                     }, {
                         xtype: 'resourcebookingusergrid',
                         itemId: 'userSelectedGrid',
                         selectedUserGrid: true,
                         title: getCommonTranslation('USERS_SELECTED'), // Users Selected
                         cls:'centerAlignTitle',
                         height: 500,
                         flex: .5
                     }]
                 },{                	
                     title: getCommonTranslation('PROGRAM_TABTITLE'), //Programs
                     closable: false,
                     margin: 0,
                     itemId:'programPanel',
                     layout: {
                         type: 'hbox'
                     },
                     items: [{
                         xtype: 'resourcebookingprogramgrid',
                         itemId: 'programListGrid',
                         selectedProgramGrid: false,
                         title: getCommonTranslation('PROGRAMS_AVAILABLE'), // Programs Available
                         cls:'centerAlignTitle',
                         height: 500,
                         flex: .5
                     }, {
                         xtype: 'resourcebookingprogramgrid',
                         itemId: 'programSelectedGrid',
                         selectedProgramGrid: true,
                         title: getCommonTranslation('PROGRAMS_SELECTED'), // Programs Selected
                         cls:'centerAlignTitle',
                         height: 500,
                         flex: .5
                     }]
                 }, {                	
                     title: getCommonTranslation('COURSE_TABTITLE'), //Courses
                     closable: false,
                     margin: 0,
                     itemId:'coursePanel',
                     layout: {
                         type: 'hbox'
                     },
                     items: [{
                         xtype: 'resourcebookingcoursegrid',
                         itemId: 'courseListGrid',
                         selectedCourseGrid: false,
                         title: getCommonTranslation('COURSES_AVAILABLE'), // Courses Available
                         cls:'centerAlignTitle',
                         height: 500,
                         flex: .5
                     }, {
                         xtype: 'resourcebookingcoursegrid',
                         itemId: 'courseSelectedGrid',
                         selectedCourseGrid: true,
                         title: getCommonTranslation('COURSES_SELECTED'), // Courses Selected
                         cls:'centerAlignTitle',
                         height: 500,
                         flex: .5
                     }]
                 },, {                	
                     title: getCommonTranslation('FACULTY_TABTITLE'), //Faculties
                     closable: false,
                     margin: 0,
                     itemId:'facultyPanel',
                     layout: {
                         type: 'hbox'
                     },
                     items: [{
                         xtype: 'resourcebookingfacultygrid',
                         itemId: 'facultyListgrid',
                         selectedFacultyGrid: false,
                         title: getCommonTranslation('FACULTIES_AVAILABLE'), // Faculties Available
                         cls:'centerAlignTitle',
                         height: 500,
                         flex: .5
                     }, {
                         xtype: 'resourcebookingfacultygrid',
                         itemId: 'facultySelectedgrid',
                         selectedFacultyGrid: true,
                         title: getCommonTranslation('FACULTIES_SELECTED'), // Faculties Selected
                         cls:'centerAlignTitle',
                         height: 500,
                         flex: .5
                     }]
                 },{
                     title: getCommonTranslation('FACILITIES_TABTITLE'), //Facilities
                     closable: false,
                     itemId:'facilitiesTabPanel',
                     margin: 0,
                     layout: {
                         type: 'hbox'
                     },
                     items: [{
                         xtype: 'resourcebookingfacilitytree',
                         itemId: 'resourcebookingfacilitytree',
                         height: 500,
                         flex: .8
                     }, {
                         xtype: 'resourcebookingformfacilityselectedpanel',
                         itemId: 'resourcebookingformfacilityselectedpanel',
                         height: 500,
                         flex: .2
                     }]
                 }, {
                     title: getCommonTranslation('EQUIPMENTS_TABTITLE'), //Equipments
                     closable: false,
                     itemId:'equipmentsTabPanel',
                     margin: 0,
                     layout: {
                         type: 'hbox'
                     },
                     items: [{
                         xtype: 'resourcebookingequipmentgrid',
                         itemId: 'equipmentListGrid',
                         selectedEquipmentGrid: false,
                         title: getCommonTranslation('EQUIPMENTS_AVAILABLE'), // Equipments Available
                         cls:'centerAlignTitle',
                         height: 500,
                         flex: .4
                     }, {
                         xtype: 'resourcebookingequipmentgrid',
                         itemId: 'equipmentSelectedGrid',
                         selectedEquipmentGrid: true,
                         title: getCommonTranslation('EQUIPMENTS_SELECTED'), // Equipments Selected
                         cls:'centerAlignTitle',
                         height: 500,
                         flex: .4
                     }]
                 }, {                	
                     title: getCommonTranslation('EXTERNAL_RESOURCE_TABTITLE'), //External Resources
                     closable: false,
                     itemId:'externalResourceTabPanel',
                     margin: 0,
                     layout: {
                         type: 'hbox'
                     },
                     items: [{
                         xtype: 'resourcebookingexternalresourcegrid',
                         itemId: 'externalResourceListGrid',
                         selectedExternalGrid: false,
                         title: getCommonTranslation('EXTERNAL_RESOURCES_AVAILABLE'), // External Resources Available
                         cls:'centerAlignTitle',
                         height: 500,
                         flex: .5
                     }, {
                         xtype: 'resourcebookingexternalresourcegrid',
                         itemId: 'externalResourceSelectedGrid',
                         selectedExternalGrid: true,
                         title: getCommonTranslation('EXTERNAL_RESOURCES_SELECTED'), // External Resources Selected
                         cls:'centerAlignTitle',
                         height: 500,
                         flex: .5
                     }]
                 }, {                	
                     title: getCommonTranslation('ADHOC_RESOURCE_TABTITLE'), //Adhoc Resource
                     closable: false,
                     itemId:'adhocResourceTabPanel',
                     margin: 0,
                     items: [{
                         xtype: 'adhocresourcesgrid',
                         itemId: 'adhocresourcesgrid',
                         height: 500
                     }]
                 },
            ]
        },{
        	xtype:'panel',
        	hidden:true,
        	frame:true,
        	header :false,            	
        	layout:{
        		type:'hbox'
        	},
        	items : [{
				xtype : 'checkboxfield',
				boxLabel : 'BOOKED',
				disabled:true
			},{
				xtype : 'checkboxfield',
				boxLabel : 'AVAILABLE',
				disabled:true,
				style: {			            
		            marginLeft: '20px'
		        } 					
			},{
				xtype : 'checkboxfield',
				boxLabel : 'PARTLY AVAILABLE',
				disabled:true,
				style: {			            
		            marginLeft: '20px'
		        } 					
			}]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            cls: 'form-fixed-footer',
            /*style: {
            	marginLeft: '20px'
                //marginTop:'-15px'
            },*/
            items: [{
                xtype: 'button',
                itemId: 'btnSaveResourceBookingForm',
                text: getCommonTranslation('SAVE'), //Save
                ui: 'CustomBtnSubmit',
                formBind: true,
                scale: CONSTANTS.BUTTONSIZE
            },{
                xtype: 'button',
                text: getExaminationTranslation('RESET'),
                itemId: 'gradeMasterResetButtonId',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE,
                /*handler: function() {
                    this.up('form').getForm().reset();
                }*/
            } /*{
                xtype: 'button',
                itemId: 'btnCancelResourceBookingForm',
                text: getCommonTranslation('CANCEL'), //Cancel
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }*/]
        }]
});
