/**
 * @author Sachin.Bangar
 * 
 * This component is used for to show Resource Booking form details. 
 */
Ext.define('Academia.view.facilitiesresources.resourcebooking.ResourceBookingListSearchForm', {
    extend: 'Ext.form.FormPanel',
    alias: 'widget.resourcebookinglistsearchform',
    autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	standardSubmit: false,
	plugins : "formlabelrequired",
    items: [{
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
    	items:[/*{
            xtype: 'textfield',
            name: 'id',
            itemId: 'ID',
            fieldLabel: getCommonTranslation('BOOKING_ID')
        }, */{
            xtype: 'customcombobox',
            name: 'bookingPurpose',
            itemId: 'cmbBookingPurpose',
            fieldLabel: getCommonTranslation('BOOKING_PURPOSE'),
            store: 'facilitiesresources.resourcebooking.ResourceBookingPurposeStore',
            valueField: 'id',
            displayField: 'value',
            editable: false,
            triggerAction: 'all',
            forceSelection: true
        }, {
            xtype: 'customcombobox',
            name: 'eventId',
            itemId: 'eventIdItemId',
            fieldLabel: getCommonTranslation('EVENT_NAME'),
            store: 'facilitiesresources.resourcebooking.employeePortal.EmployeeEventNameStore',
            valueField: 'id',
            displayField: 'value',
            queryParam: 'qry',
            triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
            enableKeyEvents: 'true',
            minChars: 3,
            typeAhead: false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            triggerAction: '',
            hideTrigger: false,
            forceSelection: true,
            maxLength: 100,
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.width = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                        '{studentCode} / {studentName}' +
                        '</div>';
                }
            },
        },{
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('CALENDAR_NAME'),
            store : 'servicerequest.eventcalendar.EventCalendarName',
            editable : false,
            name: 'calendarName',
            itemId: 'calendarName',
            valueField: 'id',
            displayField: 'value'
        }/*{
            xtype: 'customcombobox',
            name: 'status',
            itemId: 'adhocStatus',
            fieldLabel: getCommonTranslation('ADHOC_RESOURCE_STATUS'),
            store: 'facilitiesresources.resourcebooking.AdhocStatusStore',
            valueField: 'name',
            displayField: 'value',
            editable: false,
            triggerAction: 'all',
            forceSelection: true
        }*/]
    },{
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
    	items:[{
            xtype: 'datefield',
            name: 'eventDate',
            itemId: 'eventDate',
            vtype: 'daterange',
            endDateField: 'toDate',
            fieldLabel: getCommonTranslation('EVENT_BOOKED_FROM_DATE'),
            editable: false,
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            format: CONSTANTS.DATE_FORMAT
        }, {
            xtype: 'datefield',
            name: 'toDate',
            itemId: 'toDate',
            vtype: 'daterange',
            startDateField: 'eventDate',
            fieldLabel: getCommonTranslation('EVENT_BOOKED_TO_DATE'),
            editable: false,
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            format: CONSTANTS.DATE_FORMAT
        }]
    }, /*{
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
    	items:[{
    		xtype: 'multiselectcombofield',
    		width: 462,
    		name: 'multiselectAcademyLocation',
    		itemId: 'multiselectAcademyLocationId',
    		overridetSubmitData: true,
    		fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
    		store:'common.AcademyLocationNameSeparated',
    		displayField:'value',
    		valueField:'id',
    		maxLength:400
    	}, {
            xtype: 'customcombobox',
            name: 'status',
            itemId: 'adhocStatus',
            fieldLabel: getCommonTranslation('ADHOC_RESOURCE_STATUS'),
            store: 'facilitiesresources.resourcebooking.AdhocStatusStore',
            valueField: 'name',
            displayField: 'value',
            editable: false,
            triggerAction: 'all',
            forceSelection: true
        }]
    },*/ {
		xtype: 'fieldset',
		collapsible : true,
		collapsed: true,
		title: getCommonTranslation('MORE_FILTERS'),
		titleCollapse: true,
		autoScroll: false,
		defaults : {
			labelAlign:'top',
//			tdAttrs: { style: 'padding: 5px;' }
		},
		style: {
          	 marginTop: '33px!important'
         },
		items:[{
            xtype: 'customcombobox',
            name: 'status',
            itemId: 'adhocStatus',
            fieldLabel: getCommonTranslation('ADHOC_RESOURCE_STATUS'),
            store: 'facilitiesresources.resourcebooking.AdhocStatusStore',
            labelAlign: 'top',
            width: 256,
            valueField: 'name',
            displayField: 'value',
            editable: false,
            triggerAction: 'all',
            forceSelection: true
        },{
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
    	itemId: 'comboFieldContainer',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
    	items:[{
			xtype:'customcombobox',
			itemId:'resourceGroupCombo',
			fieldLabel:getCommonTranslation('RESOURCE_GROUP'),
			store:'facilitiesresources.resourcebooking.EventResourceGroupStore',
			valueField : 'name',
			displayField : 'value',			
			editable:false,
			triggerAction:'all',
			fourceSelection:true		
		}, {
			xtype:'customcombobox',
			itemId:'resourceTypeCombo',
			fieldLabel:getCommonTranslation('RESOURCE_TYPE'),
			//store:'facilitiesresources.resourcebooking.ResourceTypeStore',
			valueField : 'id',
			displayField : 'value',
			editable:false,
			disabled: true,
			allowBlank: false,
			triggerAction:'all',
			fourceSelection:true,
	        listeners: {
	            render: function(combo) {
	                var store = Ext.create('Academia.store.facilitiesresources.resourcebooking.ResourceTypeStore');
	                combo.bindStore(store);
	            }
	        }		
		}, {
			xtype : 'livesearchcombo',
			itemId : 'facility',
			fieldLabel : getCommonTranslation('SELECT_FACILITY'),
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			queryParam : 'searchText',
//			store:'Academia.store.facilitiesresources.resourcebooking.InternalFacilityResourceListStore',
		//	queryMode: 'local',
			hidden: true,
			disabled: true,
			name : 'facility',
			allowBlank: false,
			typeAhead: true,
			remoteFilter: true,
			displayTpl :new Ext.XTemplate(
					'<tpl for=".">',
					'{value}',
					'</tpl>'
			),
	        listeners: {
	            render: function(combo) {
	                var store = Ext.create('Academia.store.facilitiesresources.resourcebooking.InternalFacilityResourceListStore');
	                combo.bindStore(store);
	            }
	        }
		}, {
			xtype : 'livesearchcombo',
			itemId : 'equipment',
			queryParam : 'searchText',
			fieldLabel : getCommonTranslation('SELECT_EQUIPMENT'),
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			//store:'Academia.store.facilitiesresources.resourcebooking.IndependentEquipmentResourceListStore',
			//queryMode: 'local',
			hidden: true,
			disabled: true,
			allowBlank: false,
			remoteFilter: true,
			name : 'equipment',
			typeAhead: true,
			displayTpl :new Ext.XTemplate(
					'<tpl for=".">',
					'{value}',
					'</tpl>'
			),
	        listeners: {
	            render: function(combo) {
	                var store = Ext.create('Academia.store.facilitiesresources.resourcebooking.IndependentEquipmentResourceListStore');
	                combo.bindStore(store);
	            }
	        }
		}, {
			xtype : 'livesearchcombo',
			itemId : 'external',
			queryParam : 'searchText',
			fieldLabel : getCommonTranslation('SELECT_EXTERNAL_RESOURCE'),
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			//store:'Academia.store.facilitiesresources.resourcebooking.ExternalFacilityEquipmentListStore',
		//	queryMode: 'local',
			hidden: true,
			disabled: true,
			allowBlank: false,
			typeAhead: true,
			remoteFilter: true,
			name : 'external',
			displayTpl :new Ext.XTemplate(
					'<tpl for=".">',
					'{value}',
					'</tpl>'
			),
	        listeners: {
	            render: function(combo) {
	                var store = Ext.create('Academia.store.facilitiesresources.resourcebooking.ExternalFacilityEquipmentListStore');
	                combo.bindStore(store);
	            }
	        }
		}, {
			xtype : 'livesearchcombo',
			itemId : 'faculty',
			queryParam : 'searchText',
			fieldLabel : getCommonTranslation('SELECT_FACULTY'),
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			//store:'Academia.store.facilitiesresources.resourcebooking.ListOfWhetherFacultyStore',
			//queryMode: 'local',
			hidden: true,
			disabled: true,
			allowBlank: false,
			typeAhead: false,
			remoteFilter: true,
			name : 'faculty',
			displayTpl :new Ext.XTemplate(
					'<tpl for=".">',
					'{value}',
					'</tpl>'
			),
	        listeners: {
	            render: function(combo) {
	                var store = Ext.create('Academia.store.facilitiesresources.resourcebooking.ListOfWhetherFacultyStore');
	                combo.bindStore(store);
	            }
	        }
		}, {
			xtype : 'livesearchcombo',
			itemId : 'user',
			queryParam : 'searchText',
			fieldLabel : getCommonTranslation('SELECT_RESOURCE_USER'),
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			//store:'Academia.store.facilitiesresources.resourcebooking.ListOfWhetherFacultyStore',
			//queryMode: 'local',
			hidden: true,
			disabled: true,
			allowBlank: false,
			typeAhead: true,
			remoteFilter: true,
			name : 'user',
			displayTpl :new Ext.XTemplate(
					'<tpl for=".">',
					'{value}',
					'</tpl>'
			),
	        listeners: {
	            render: function(combo) {
	                var store = Ext.create('Academia.store.facilitiesresources.resourcebooking.ListOfWhetherFacultyStore');
	                combo.bindStore(store);
	            }
	        }
		}, {
			xtype : 'livesearchcombo',
			itemId : 'program',
			fieldLabel : getCommonTranslation('SELECT_RESOURCE_PROGRAM'),
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
//			store:'Academia.store.facilitiesresources.resourcebooking.ProgramBatchSectionPeriodListStore',
			//queryMode: 'local',
			queryParam : 'searchText',
			hidden: true,
			disabled: true,
			allowBlank: false,
			typeAhead: true,
			remoteFilter: true,
			name : 'program',
			displayTpl :new Ext.XTemplate(
					'<tpl for=".">',
					'{value}',
					'</tpl>'
			),
	        listeners: {
	            render: function(combo) {
	                var store = Ext.create('Academia.store.facilitiesresources.resourcebooking.ProgramByAcademyLocationIdsListStore');
	                combo.bindStore(store);
	            }
	        }
		}, {
			xtype : 'customcombobox',
			itemId : 'course',
			fieldLabel : getCommonTranslation('SELECT_RESOURCE_COURSE'),
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
//			store:'Academia.store.facilitiesresources.resourcebooking.CourseVariantsListStore',
			//queryMode: 'local',
			queryParam : 'courseName',
			hidden: true,
			disabled: true,
			allowBlank: false,
			typeAhead: false,
			remoteFilter: true,
			name : 'course',
			valueField: 'id',
			displayField: 'code',
			minChars: 3,
			triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents: 'true',
			triggerAction: '',
			/*displayTpl :new Ext.XTemplate(
					'<tpl for=".">',
					'{code}',
					'</tpl>'
			),*/
	        listeners: {
	            render: function(combo) {
	                var store = Ext.create('Academia.store.facilitiesresources.resourcebooking.CourseVariantsListStore');
	                combo.bindStore(store);
	            }
	        }
		}]
    }, /*{
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
    	items:[{
            xtype: 'datefield',
            name: 'eventDate',
            itemId: 'eventDate',
            vtype: 'daterange',
            endDateField: 'toDate',
            fieldLabel: getCommonTranslation('EVENT_BOOKED_FROM_DATE'),
            editable: false,
            submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              }
        }, {
            xtype: 'datefield',
            name: 'toDate',
            itemId: 'toDate',
            vtype: 'daterange',
            startDateField: 'eventDate',
            fieldLabel: getCommonTranslation('EVENT_BOOKED_TO_DATE'),
            editable: false,
            submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              }
        }]
    },*/ {
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
    	items:[{
            xtype: 'timefield',
            name: 'timeFrom',
            itemId: 'timeFrom',
            fieldLabel: getCommonTranslation('EVENT_BOOKED_FROM_TIME'),
            format: CONSTANTS.DISPLAY_TIME_FORMAT,
            increment: 30,
            vtype: 'timerange',
            endTimeField: 'timeTo'
        }, {
            xtype: 'timefield',
            name: 'timeTo',
            itemId: 'timeTo',
            fieldLabel: getCommonTranslation('EVENT_BOOKED_TO_TIME'),
            format: CONSTANTS.DISPLAY_TIME_FORMAT,                    
            increment: 30,
            vtype: 'timerange',
            startTimeField: 'timeFrom'
        }]
    }]
    }, {
    	xtype : 'fieldcontainer',
		width : 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout : {
			type : 'hbox'
		},
		items : [ {
			xtype : 'button',
			text : getCommonTranslation('SEARCH'),
			itemId : 'searchButtonId',
			//buttonAlign : 'left',
			ui : 'CustomBtnSubmit',
			formBind: true,
			scale: CONSTANTS.BUTTONSIZE
		}, {
			xtype: 'button',
			text : getCommonTranslation('RESET'),
			itemId : 'resetButtonId',
			//buttonAlign : 'left',
			ui : 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		},
//		{
//			xtype: 'button',
//			text : getCommonTranslation('view_Event_Detail'),
//			itemId : 'viewEventDetailItemId',
//			buttonAlign : 'left',
//			ui : 'CustomBtnCancel',
//			scale: CONSTANTS.BUTTONSIZE
//		}
		]
	}]
});