/**
 * @author Rohit Thadani
 * 
 * This component is used for to show Resource Booking form details. 
 */
Ext.define('Academia.view.facilitiesresources.resourcebooking.StudentResourceBookingListSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.studentresourcebookinglistsearchform',
    autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	standardSubmit: false,
	plugins : "formlabelrequired",
    items: [{
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
    	items:[/*{
            xtype: 'textfield',
            name: 'id',
            itemId: 'ID',
            fieldLabel: getCommonTranslation('BOOKING_ID')
        }, */ {
			xtype: 'customcombobox',
			name: 'committee',
			itemId:'committeeItemId',
			store:'committee.committee.StudentCommitteeStore',
			displayField:'valueCode',
			valueField:'id',
			queryParam:'nameOrCode',
			typeAhead:false,
			minChars:3,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			},
			fieldLabel:getCommonTranslation("COMMITTEE_CODE_NAME")
        }, {
            xtype: 'customcombobox',
            name: 'eventId',
            itemId: 'eventIdItemId',
            fieldLabel: getCommonTranslation('EVENT_NAME'),
            store: 'facilitiesresources.resourcebooking.employeePortal.EmployeeEventNameStore',
            valueField: 'id',
            displayField: 'value',
            queryParam: 'qry',
            triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
            enableKeyEvents: 'true',
            minChars: 3,
            typeAhead: false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            triggerAction: '',
            hideTrigger: false,
            forceSelection: true,
            maxLength: 100,
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.width = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                        '{studentCode} / {studentName}' +
                        '</div>';
                }
            }
            /*xtype: 'textfield',
            name: 'eventName',
            fieldLabel: getCommonTranslation('EVENT_NAME'), //Event Name
            allowBlank: true,
            maxLength: 255*/
        }/*{
            xtype: 'customcombobox',
            name: 'status',
            itemId: 'adhocStatus',
            fieldLabel: getCommonTranslation('ADHOC_RESOURCE_STATUS'),
            store: 'facilitiesresources.resourcebooking.AdhocStatusStore',
            valueField: 'name',
            displayField: 'value',
            editable: false,
            triggerAction: 'all',
            forceSelection: true
        }*/]
    },{
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
    	items:[{
            xtype: 'datefield',
            name: 'eventDate',
            itemId: 'eventDate',
            vtype: 'daterange',
            endDateField: 'toDate',
            fieldLabel: getCommonTranslation('EVENT_BOOKED_FROM_DATE'),
            editable: false,
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            format: CONSTANTS.DATE_FORMAT
        }, {
            xtype: 'datefield',
            name: 'toDate',
            itemId: 'toDate',
            vtype: 'daterange',
            startDateField: 'eventDate',
            fieldLabel: getCommonTranslation('EVENT_BOOKED_TO_DATE'),
            editable: false,
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            format: CONSTANTS.DATE_FORMAT
        }]
    }, /*{
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
    	items:[{
    		xtype: 'multiselectcombofield',
    		width: 462,
    		name: 'multiselectAcademyLocation',
    		itemId: 'multiselectAcademyLocationId',
    		overridetSubmitData: true,
    		fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
    		store:'common.AcademyLocationNameSeparated',
    		displayField:'value',
    		valueField:'id',
    		maxLength:400
    	}, {
            xtype: 'customcombobox',
            name: 'status',
            itemId: 'adhocStatus',
            fieldLabel: getCommonTranslation('ADHOC_RESOURCE_STATUS'),
            store: 'facilitiesresources.resourcebooking.AdhocStatusStore',
            valueField: 'name',
            displayField: 'value',
            editable: false,
            triggerAction: 'all',
            forceSelection: true
        }]
    },*/{
    	xtype : 'fieldcontainer',
		width : 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items : [ {
			xtype : 'button',
			text : getCommonTranslation('SEARCH'),
			itemId : 'searchButtonId',
			buttonAlign : 'left',
			ui : 'CustomBtnSubmit',
			formBind: true,
			scale: CONSTANTS.BUTTONSIZE
		}, {
			xtype: 'button',
			text : getCommonTranslation('RESET'),
			itemId : 'resetButtonId',
			buttonAlign : 'left',
			ui : 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		} ]
	}]
});