/**
 * @author Ranga
 * 
 */
Ext.define('Academia.view.facilitiesresources.resourcemaster.FacilityMasterUploadForm',{
	extend: 'Ext.form.Panel',
	alias: 'widget.facilitymasteruploadform',
	autoScroll: false,
	frame: false,
	standardSubmit: false,
	//cls:'customSearchPanel',
	defaults: {
		width: 256,
		labelAlign: 'top'
	},
	items : [{
		xtype:'uploadoptionradiogroup',
		width: 300,
		margin: 0,
		itemId:'facilityMasterListUploadOptionRadioGroupItemId',
	},{
		xtype:'fieldcontainer',
		width:'auto',
		layout : 'hbox',
		items: [{
			xtype: 'customcombobox',
			name:'uploadType',
			itemId:'uploadTypeItemId',
			labelAlign: 'top',
			store:'facilitiesresources.resourcemaster.FacilityMasterTypeStore',
			fieldLabel : getProgramandcourseTranslation('TEMPLATE_FOR'),	
			valueField: 'id',
			displayField: 'value',
			allowBlank:false,
			triggerAction : 'all',
			editable: false,
			maxLength: 40,
			width: 200
		},{
			xtype: 'customcombobox',
			name: 'importUtilityMasterId',
			itemId:'moduleName',
			labelAlign: 'top',
			store:'importutility.ModuleName',
			fieldLabel: getCommonTranslation('TEMPLATE_NAME'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true,
			allowBlank:false
		}]
	},{ 	
		xtype:'fieldcontainer',
		items: [{
		xtype : 'filefield',
		ui : 'CustomBtnThird',
		width: 536,
		fieldLabel : getCommonTranslation('UPLOAD_FILE'),
		buttonText : getCommonTranslation('BROWSE_FILE'),
		itemId : 'uploadFileField',
		labelAlign: 'top',
		name : 'file',
		allowBlank:false,
		validateOnChange : true,
		listeners:{
            change: function(fileField, value) {
                value = value.replace('C:\\fakepath\\', '');
                var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                fileField.setRawValue(newValue);
                if (!isNullOrEmpty(newValue)) {
                    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                    var baseController = Academia.getApplication().getController('Academia.controller.base.BaseController');
                    if (!baseController.isValidFileExtensionForLoader(extension)) {
                        fileField.reset();
                        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BDU_PLEASE_UPLOAD_CSV_FILE'));
                    }
                }
            }
        }
	}]},{ 	
		xtype:'fieldcontainer',
		width:'auto',
		layout: 'hbox',
		cls: 'customSearchPanelBtnsFieldContainerCls CustomSearchPanelBtnLeftMargin',
		items: [{
			xtype: 'button',
			action: 'Submit',
			text: getTranslation('UPLOAD_DATA'),
			formBind: true,
			itemId: 'uploadId',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			ui: 'CustomBtnCancel',
			itemId: 'resetBtn',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});
