Ext.define('Academia.view.facultyPortal.attendance.CaptureAttendanceInnerGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	cls: 'captureAttendanceGridCls',
	alias: 'widget.captureattendanceinnergrid',
	title:getProgramandcourseTranslation('STUDENT_ATTENDANCE_LIST'),
	border:true,
	store : 'attendance.StudentAttendanceList',
	viewConfig: {
		emptyText: getCommonTranslation('EMPTY_MESSAGE')
	},
	overflowY: 'visible',
	height: 'auto',
	isGridConfigurable: true,
	enableColumnHide: false,
	columns : [{
		xtype: 'rownumberer',
		header: getCommonTranslation('SNO'),
		sortable:false,
		align :'left',
		flex:.5,
		sortable: false
	},/*{
		 header : 'ID',
		 hidden : true,
		 dataIndex:'id'
	 },*/{
		header :getCommonTranslation('ADMISSION_CODE'),
		dataIndex : 'admissionCode',
		sortable:false,
		flex:1,
		sortable: true
	},{
		header :getCommonTranslation('STUDENT_CODE'),
		dataIndex : 'studentCode',
		sortable:false,
		flex:1,
		sortable: true
	},{
		header : getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		sortable:false,
		flex:1,
		sortable: true
	},{
		header : getCommonTranslation('STUDENT_FIRST_NAME'),
		dataIndex : 'firstName',
		sortable:false,
		flex:1,
		hidden :true,
		sortable: true
	},{
		header : getCommonTranslation('STUDENT_MIDDLE_NAME'),
		dataIndex : 'middleName',
		sortable:false,
		flex:1,
		hidden :true,
		sortable: true
	},{
		header : getCommonTranslation('STUDENT_LAST_NAME'),
		dataIndex : 'lastName',
		sortable:false,
		flex:1,
		sortable: true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(val=='null'){

				return '';
			}else{
				return val;
			}
		}
	},{
		 header : getCommonTranslation('PROGRAM'),
		 dataIndex : 'programName',
		 sortable:false,
		 flex:1,
		 sortable:true
	 },{
		xtype : 'checkcolumn', 
		flex:.75,
		itemId:'presentId',
		text : getCommonTranslation('PRESENT'),
		sortable:false,
		dataIndex : 'present',
		sortable: true,
	},{
		xtype : 'checkcolumn',
		text : getCommonTranslation('ABSENT'),
		dataIndex :  'absent',
		sortable:false,
		flex : .75,
		sortable: true
	},{
		header : getCommonTranslation('OTHERS'),
		dataIndex : 'attendanceStatus',
		sortable:false,
		flex : .75,
		sortable: true,
		editor : {
			xtype: 'customcombobox',
			itemId:'StudentAttendanceStatus_Id',
			store:'attendance.AttendanceMarkingTypeStore',
			valueField : 'value',
			displayField : 'value',
			typeAhead:false,
			forceSelection : true
		},
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(isNullOrEmpty(val)){
				rec.tdCls = 'gridInputCustomStyle'; 
				return getExaminationTranslation('CLICK_TO_ENTER');
			}else{
				return val;
			}
		}
	},{
		header: getCommonTranslation('REMARKS'),
		dataIndex: 'comment',
		flex:.75,
		sortable: true,
		editor : {
			xtype: 'textfield',
			name: 'attendanceComment',
			maxLength:255
		},
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(isNullOrEmpty(val)){
				rec.tdCls = 'gridInputCustomStyle'; 
				return getExaminationTranslation('CLICK_TO_ENTER');
			}else{
				return val;
			}
		}
	}],
	plugins: [{
		ptype : 'cellediting',
		clicksToEdit: 1,
		listeners: {
			edit: function(obj, editor, context){
				var this$= this;
				var grid = obj.grid;
				var store = grid.getStore();
				var models = grid.getStore().getRange();
				var gridCount = Ext.getCmp('studentAttendancecountGridId');
				var field = grid.down('#StudentAttendanceStatus_Id');
				if(obj.context.column.field.name != 'attendanceComment'){
					if(!isNullOrEmpty(field.getValue())){
						for(var i =0; i<store.data.length;i++){
							if(editor.rowIdx==i){
								models[i].set('present', false);
								models[i].set('absent', false);
								Ext.defer(function() {
									var preCount=0,absCount=0, other=0, presentSummaryCount = 0, absentSummaryCount= 0;
									for(var i =0; i<store.data.length;i++){
										if(models[i].data.present){
											preCount++;
											presentSummaryCount++;
										}
										else if(models[i].data.absent){
											absCount++;
											absentSummaryCount++;
										}
										else if(models[i].data.attendanceStatus){
											other++;
											for(var z = 0; z<this.grid.columnManager.columns.length;z++){
												if(this.grid.columnManager.columns[z].dataIndex == "attendanceStatus") {
													var data  = this.grid.columnManager.columns[z].field.getStore().data.items;
													for(var j= 0; j<data.length;j++){
														if(data[j].data.value == models[i].data.attendanceStatus){
															if(data[j].data.code == 'PRESENT')
																presentSummaryCount++;
															if(data[j].data.code == 'ABSENT')
																absentSummaryCount++;
															models[i].set('attendanceMarkingType' ,data[j].data.id);
															models[i].set('attendanceMarkStatus' ,data[j].data.code);
														}
													}
												}
											}
										}
									}
									var  data = {
											totalStudent:store.data.length,
											totalPresent:preCount,
											totalAbsent:absCount,
											otherCount:other,
											presentPercent:parseFloat((presentSummaryCount/store.data.length)*100).toFixed(2)+"%",
											absentPercent:parseFloat((absentSummaryCount/store.data.length)*100).toFixed(2)+"%",
									};
									var gridStore =  gridCount.getStore();
									gridStore.removeAll();
									gridStore.loadRawData(data, true);

								}, 50, this);
								break;
							}
						}
					}
				}
			}
		}
	}]
});
