/**
 * @author Abhishek Bais
 * 
 */
Ext.define('Academia.view.facultyPortal.attendance.CompleteDayPendingAttendanceReportSearch', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.completedaypendingattendancereportsearch',
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	method : 'POST',
	standardSubmit : false,
	items: [{
		xtype : 'fieldcontainer',
		width: 'auto',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype: 'customcombobox',
			name: 'programGroup',
			itemId:'programGroupItemId',
			fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
			store:Ext.create('Academia.store.personinfo.common.personalinfo.AttendanceReportProgramGroupStore'),
			editable: true,
			valueField: 'id',
			displayField: 'value',
			forceSelection:true,
			typeAhead:false,

		},{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('PROGRAM_BATCH_PERIOD_SECTION'),
			name : 'section',
			itemId : 'sectionItemId',
			store:Ext.create('Academia.store.attendance.facultyportal.AttendanceProgramStore'),
			displayField:'value',
			valueField:'sectionId',
			width: 536,
			typeAhead:true,
			forceSelection:true,
			minChars:3,
			queryParam:'name',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
	}, {
		xtype : 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'customcombobox',
			fieldLabel : getProgramandcourseTranslation('ATTENDANCE_STATUS'),
			width: 256,
			labelAlign: 'top',
			name : 'pendingAttendanceStatus',
			itemId : 'pendingAttendanceStatusId',
			store:Ext.create('Academia.store.attendance.PendingAttendanceStatusStore'),
			displayField : 'value',
			valueField : 'code',
			typeAhead : true,
			forceSelection : true
		},{
			xtype : 'datefield',
			fieldLabel : getProgramandcourseTranslation('START_DATE'),
			name : 'programWiseStartDate',
			itemId:'programWiseStartDate',
			endDateField : 'programWiseEndDate',
			vtype : 'daterange',
			maxValue:new Date(),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		},{
			xtype : 'datefield',
			fieldLabel :getProgramandcourseTranslation('END_DATE'),
			name : 'programWiseEndDate',
			itemId : 'programWiseEndDate',
			startDateField : 'programWiseStartDate',
			vtype : 'daterange',
			maxValue:new Date(),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout : 'hbox',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'completeDaySearchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			formBind : true,
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCourseTxCommonTranslation('RESET'),
			itemId: 'completeDayResetBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});

