/**
 * @author ravindra
 * 
 */
Ext.define('Academia.view.facultyPortal.attendance.DownloadStudentAttendanceForm',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.downloadstudentattendanceform',
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	method : 'POST',
	standardSubmit : false,
	plugins : "formlabelrequired",
	layout : {
		type : 'vbox'
	},
	defaults : {
		labelAlign : 'top',
		width: 256
	},
	items: [{
		xtype : 'fieldcontainer',
		itemId:'programBatch_Id',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'hidden',
			name : 'id'
		},{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('PROGRAM_BATCH_PERIOD_SECTION'),
			name : 'facultyStudentAttendanceProgram',
			itemId : 'facultyStudentAttendanceProgramId',
			store:Ext.create('Academia.store.attendance.facultyportal.AttendanceProgramStore'),
			displayField:'value',
			valueField:'sectionId',
			width: 536,
			allowBlank:false,
			typeAhead:true,
			forceSelection:true,
			minChars:3,
			queryParam:'name',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}
		]},{
			xtype : 'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults : {
				labelAlign : 'top'
			},
			items : [{
				xtype : 'datefield',
				width: 256,
				fieldLabel : getProgramandcourseTranslation('FROM_DATE'),
				name : 'dateOfStudentAttendance',
				itemId:'dateOfStudentAttendanceId',
				vtype : 'daterange',
				allowBlank: false,
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setMaxValue(new Date());						
						obj.setValue(new Date());
					}
				}
		},{
			xtype : 'datefield',
			width: 256,
			fieldLabel :getProgramandcourseTranslation('TO_DATE'),
			name : 'consolidateStudentEndDate',
			itemId : 'consolidateStudentEndDateId',
			vtype : 'daterange',
			allowBlank: false,
			maxValue:new Date(),
			listeners: {
				render: function(obj) {
					obj = dateFormatRender(obj);	
					obj.setMaxValue(new Date());						
					obj.setValue(new Date());
				}	
			}
			
		}]},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout : 'hbox',
			cls: 'customSearchPanelBtnsFieldContainerCls',
			items: [{
	           	 xtype: 'button',
	        	 text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
	             itemId: 'programBatchStudentDownoladBtnId',
	             formBind : true,
	             ui: 'CustomBtnSubmit'
	        },{
				xtype: 'button',
				text: getCourseTxCommonTranslation('RESET'),
				itemId: 'resetStudentAttendenceBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
});
