/**
 * @author ravindra
 * 
 */
Ext.define('Academia.view.facultyPortal.attendance.DownloadStudentCourseLevelAttendanceForm',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.downloadstudentcourselevelattendanceform',
	plugins : "formlabelrequired",
	frame: false,
	border:false,
	autoScroll:false,
	method : 'POST',
	cls:'customSearchPanel',
	layout : {
		type : 'vbox'
	},
	defaults : {
		labelAlign : 'top',
		width: 256
	},
	items: [{
		xtype : 'fieldcontainer',
		itemId:'programBatch_Id',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
			name : 'ACADEMIC_TERM',
			itemId : 'studentAcademicTermId',
			displayField : 'value',
			valueField : 'id',
			allowBlank:false,
			typeAhead : true,
			forceSelection : true,
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.AcademicTermStore');
					combo.bindStore(store)
				}
			}
		},{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('COURSE_VARIANT'),
			name : 'studentCourseVariantId',
			itemId : 'studentCourseVariantId',
			store:Ext.create('Academia.store.attendance.facultyportal.AttendanceCourseVariantStore'),
			displayField:'courseVariantCode',
			valueField:'id',
			allowBlank:false,
			typeAhead:true,
			forceSelection:true,
			minChars:3,
			queryParam:'name',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}
		]},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout : 'hbox',
			cls: 'customSearchPanelBtnsFieldContainerCls',
			items: [{
	           	 xtype: 'button',
	        	 text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
	             itemId: 'courseLevelStudentDownoladBtnId',
	             formBind : true,
	             ui: 'CustomBtnSubmit'
	        },{
				xtype: 'button',
				text: getCourseTxCommonTranslation('RESET'),
				itemId: 'resetCourseLevelStudentAttendenceBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
});