/**
 * @author ravindra
 * 
 */
Ext.define('Academia.view.facultyPortal.attendance.SessionWiseStudentAttendanceSummarySearch', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.sessionwisestudentattendancesummarysearch',  
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	method : 'POST',
	plugins : "formlabelrequired",
	standardSubmit : false,
	items: [{
		xtype : 'fieldcontainer',
		width: 'auto',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype : 'customcombobox',
			name : 'academyLocation',
			itemId:'academyLocationId',
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store:'attendance.attendancereport.AcadmyByAdmission',
			width: 256,
			valueField : 'id',
			displayField : 'value',
			allowBlank : false,
			minChars:3,
			typeAhead : true,
			forceSelection:true,
			hideTrigger:false,
			triggerAction: 'all',
			queryParam:'qry',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype : 'customcombobox',
			name : 'sessionWiseAttendanceSummaryAcademicTerm',
			itemId : 'sessionWiseAttendanceSummaryAcademicTermId',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),
			store :Ext.create('Academia.store.common.AcademicTermStore'),
			valueField : 'id',
			displayField : 'value',
			forceSelection:true,
			typeAhead:false,
			allowBlank:false

		},{
			xtype: 'customcombobox',
			name:'sessionWiseAttendanceSummaryStudentName',
			itemId:'sessionWiseAttendanceSummaryStudentNameId',
			store: 'coursetransaction.studentenrollment.studentenrollmentdetail.FacultyParamCourseStudentStore',
			fieldLabel:getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}' +
					'</div>';
				}
			}
		}]
	}, {
		xtype : 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'statusCombo',
			name: 'STATUS',
			itemId:'statusComboItemId',
			width: 256,
			value:true,
			editable:false
		},{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('PROGRAM_BATCH_PERIOD_SECTION'),
			name : 'sessionWiseAttendanceSummaryProgram',
			itemId : 'sessionWiseAttendanceSummaryProgramId',
			store:Ext.create('Academia.store.attendance.facultyportal.AttendanceProgramStore'),
			displayField:'value',
			valueField:'sectionId',
			width: 536,
			typeAhead:true,
			forceSelection:true,
			minChars:3,
			queryParam:'name',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
	},{
		xtype : 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
			width: 256,
			fieldLabel: getProgramandcourseTranslation('SESSION_NO'),
			name:'sessionNo1',
			itemId: 'sessionWiseSessionItemId',
			displayField: 'val',
			valueField: 'code',
			allowBlank:true,
			typeAhead:true,
			value:1,
			queryMode:'local',
			forceSelection:true
		}]
	},{
		xtype: 'fieldset',
		collapsible : true,
		title: getCommonTranslation('MORE_DETAILS'),
		itemId : 'moreDetailId',
		defaults : {
			labelAlign:'top',
		},
		style: {
			marginTop: '33px!important'
		},
		items:[{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getCommonTranslation('START_DATE'),
				name : 'startDate',
				itemId : 'startDate',
				endDateField : 'tillDate',
				vtype : 'daterange',
				//maxValue:new Date(),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					},
					change: function(me, newValue, oldValue, eOpts) {
						if(!isNullOrEmpty(newValue))
						{
							var date = me.parseDate(newValue);
    						var startDate = me.up().down("#startDate");
    						var end = me.up().down("#tillDate");
    						var newDate = date.setMonth(date.getMonth()+6);
	                    	newDate = new Date(newDate);
	                    	end.setMaxValue(newDate);
	                    	startDate.isValid();
						}
					}
				}
			},{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getCommonTranslation('END_DATE'),
				name : 'tillDate',
				itemId : 'tillDate',
				startDateField : 'startDate',
				//maxValue:new Date(),
				vtype : 'daterange',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					},
					change: function(me, newValue, oldValue, eOpts) {
						if(!isNullOrEmpty(newValue))
						{
    						var date = me.parseDate(newValue);
    						var startDate = me.up().down("#startDate");
    						var endDate = me.up().down("#tillDate");
	                    	var newDate = date.setMonth(date.getMonth()-6);
	                    	newDate = new Date(newDate);
	                    	startDate.setMinValue(newDate);
	                    	endDate.isValid();
						}
					}
				}
			}]
		}, {
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype : 'numberfield',
				name : 'attendancePercentageFrom',
				itemId : 'attendancePercentageFromSessionId',
				fieldLabel : getCourseTxCommonTranslation('ATTENDANCE_PERCENTAGE_FROM'),
				minValue : 0,
				maxValue:100,
				mouseWheelEnabled :false,
				hideTrigger :true,
				allowExponential:false,
				allowDecimals:false,
				validator : function(minValue) {
					var minAbsentPercentageField = Ext.ComponentQuery.query('numberfield#minAbsentPercentageSessionId')[0];
					var attendancePercentageToField = Ext.ComponentQuery.query('numberfield#attendancePercentageFromSessionId')[0];
					var maxValue = attendancePercentageToField.getValue();
					if (minValue > 0 && (maxValue > 0|| maxValue=="" || maxValue== null)) {
						minAbsentPercentageField.setDisabled(true);
					}else if(minValue=="" && (maxValue==""|| maxValue==null)) {
						minAbsentPercentageField.setDisabled(false);
					}
					if(maxValue!="" && maxValue!= null ){
						if(minValue <= maxValue){
							attendancePercentageToField.clearInvalid();
		 	   				 return true;
						}else{
							return getCourseTxCommonTranslation('ATTENDANCE_PERCENTAGE_FROM')+' should be less then '+getCourseTxCommonTranslation('ATTENDANCE_PERCENTAGE_TO');
						}
							
					}else{
						return true;
					}
					
				}
			},{
				xtype : 'numberfield',
				name : 'attendancePercentageTo',
				itemId : 'attendancePercentageToSessionId',
				fieldLabel : getCourseTxCommonTranslation('ATTENDANCE_PERCENTAGE_TO'),
				minValue : 0,
				maxValue:100,
				mouseWheelEnabled :false,
				hideTrigger :true,
				allowExponential:false,
				allowDecimals:false,
				validator : function(maxVal) {
					var minAbsentPercentageField = Ext.ComponentQuery.query('numberfield#minAbsentPercentageSessionId')[0];
					var attendancePercentageFromField = Ext.ComponentQuery.query('numberfield#attendancePercentageFromSessionId')[0];
					var minValue = attendancePercentageFromField.getValue();
					if (maxVal > 0 && (minValue > 0 || minValue=="" || minValue== null)) {
						minAbsentPercentageField.setDisabled(true);
						
					} else if(maxVal=="" && (minValue==""|| minValue==null)) {
						minAbsentPercentageField.setDisabled(false);
					}
					if(minValue!="" && minValue!= null &&
							maxVal!="" && maxVal!=null){
						if( maxVal>= minValue){
							attendancePercentageFromField.clearInvalid();
		 	   				 return true;
						}else{
							return getCourseTxCommonTranslation('ATTENDANCE_PERCENTAGE_TO')+' should be greater then '+getCourseTxCommonTranslation('ATTENDANCE_PERCENTAGE_FROM');
						}
							
					}else{
						return true;
					}
				}
			}
			]}, {
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype : 'numberfield',
				name : 'minAbsentPercentage',
				itemId : 'minAbsentPercentageSessionId',
				fieldLabel : getCourseTxCommonTranslation('MIN_ABSENT_PERCENTAGE'),
				value : 0,
				minValue : 0,
				maxValue:100,
				mouseWheelEnabled :false,
				hideTrigger :true,
				allowExponential:false,
				allowDecimals:false,
				validator : function(val) {
					var attendancePercentageFromField = Ext.ComponentQuery.query('numberfield#attendancePercentageFromSessionId')[0];
					var attendancePercentageToField = Ext.ComponentQuery.query('numberfield#attendancePercentageToSessionId')[0];
					if (val > 0) {
						attendancePercentageFromField.setDisabled(true);
						attendancePercentageToField.setDisabled(true);
					} else if(val==0) {
						attendancePercentageFromField.setDisabled(false);
						attendancePercentageToField.setDisabled(false);
					}
					return true;
				}
			},{
				xtype : 'numberfield',
				name : 'absentAboveNumberOfSessions',
				itemId : 'absentAboveNumberOfSessions',
				fieldLabel : getCourseTxCommonTranslation('ABSENTS_ABOVE_NO_OF_DAYS_SESSIONS'),
				value : 0,
				minValue : 0,
				maxValue:365,
				mouseWheelEnabled :false,
				hideTrigger :true,
				allowExponential:false,
				allowDecimals:false
			}]
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout : 'hbox',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'sessionAttendanceSummaySearchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			formBind : true,
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCourseTxCommonTranslation('RESET'),
			itemId: 'sessionAttendanceSummayResetBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});
