/**
 *  @author ravindra
 */
Ext.define('Academia.view.facultyPortal.attendance.StudentCourseAttendanceReportGridForFaculty', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.studentcourseattendancereportgridforfaculty',
	store :'attendance.facultyportal.CourseLevelAttendanceReportStore',
	title: getCommonTranslation('STUDENT_ATTENDANCE_REPORT'),
	border: true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	selType:'checkboxmodel',
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	tbar : [{
		xtype: 'button',
		itemId: 'btnDeleteStudentAttendance',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation("DELETE"),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype : 'button',
		itemId : 'btnUpdateAttendance',
		tooltip : getProgramandcourseTranslation('UPDATE_ATTENDANCE'),
		text : getProgramandcourseTranslation('UPDATE_ATTENDANCE')
	},
	'->'],
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'attendance.facultyportal.CourseLevelAttendanceReportStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;    
		grid.addExportToolBarItems(grid,true);
		this.callParent(arguments); 
	},
	columns: [{
		header : getCommonTranslation('ADMISSION_CODE'),
		dataIndex : 'admissionCode',
		flex:1
	},{
		header : getCommonTranslation('STUDENT_CODE'),
		dataIndex : 'studentCode',
		flex:1
	},{
		header : getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex:1
	},{
		header : getCommonTranslation('GENDER'),
		dataIndex : 'gender',
		flex : 1,
		hidden :true
	},{
		header : getCommonTranslation('FIRST_NAME'),
		dataIndex : 'firstName',
		flex : 1,
		hidden :true
	},{
		header : getCommonTranslation('MIDDLE_NAME'),
		dataIndex : 'middleName',
		flex : 1,
		hidden :true
	},{
		header : getCommonTranslation('LAST_NAME'),
		dataIndex : 'lastName',
		flex : 1
	},{
		header : getProgramandcourseTranslation('COURSE'),
		dataIndex : 'courseName',
		flex:1
	},{
		header : getCommonTranslation('COURSE_VARIANT'),
		dataIndex : 'courseVariantName',
		flex : 1
	},{
		header : getCommonTranslation('SECTION_NAME'),
		dataIndex : 'sectionCode',
		flex : 1
	},{
		header : getCommonTranslation('ATTENDANCE_DATE'),
		dataIndex : 'dateOfAttendance',
		flex : 1,
		renderer: function(date) {
			return dateRender(date);
		}
	},{
		header : getCommonTranslation('FROM_TIME'),
		dataIndex : 'fromTime',
		flex : 1,
		renderer: function(time) {
			return timeRender(time);
		}
	},{
		header : getCommonTranslation('TO_TIME'),
		dataIndex : 'toTime',
		flex : 1,
		renderer: function(time) {
			return timeRender(time);
		}
	},{
		header : getCommonTranslation('FACULTY_NAME'),
		dataIndex : 'facultyName',
		flex : 1
	},{
		header : getCommonTranslation('ATTENDANCE_STATUS'),
		dataIndex : 'attendanceStatus',
		flex : 1
	},{
		header : getCommonTranslation('WHETHER_ATTENDANCE_MARKED'),
		dataIndex : 'lastUpdate',
		sortable : true,
		flex : 1,
		renderer:function(timestamp) {
			return dateTimeRender1(timestamp);
		}
	},{
		header: getProgramandcourseTranslation('REMARKS'),
		dataIndex: 'attendanceComment',
		flex:1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(isNullOrEmpty(val)){
				return "";
			} else {
				rec.tdAttr = 'data-qtip="' + val + '"';
				rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 1;-webkit-box-orient: vertical;line-height: 15px;max-height: 30px;max-width: 17ch;';
				return val;
			}
		}
	}]
});