/**
 * @author Dharmendra.prajapati
 * 
 */
Ext.define('Academia.view.facultyPortal.detailScheduleFaculty.DetailedScheduleFacultySearchFilter',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.detailedschedulefacultysearchfilter',
	plugins : "formlabelrequired",
	autoScroll : false,
	frame: false,
	method : 'POST',
	standardSubmit : false,
	items : [{
		xtype : 'form',
		itemId:'detailedScheduleFacultySearchFormItemId',
		title : getCommonTranslation('SEARCH'),
		collapsible:true,
		collapsed:true,		
		frame: true,
		width : '100%',
		items: [{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype: 'hidden',
				name: 'section',
				itemId: 'courseSectionId'
				
			},{
				xtype: 'hidden',
				name: 'courseId',
				itemId: 'courseId',
				
			},{
				xtype: 'hidden',
				name: 'component',
				itemId: 'courseComponentId'
				
			},
			{
				xtype: 'hidden',
				name: 'sectionType',
				itemId: 'sectionTypeId'
			},
				{
				xtype: 'customcombobox',
				name: 'academicTerm',
				itemId: 'academicTermId',
				width: 256,
				fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
				store: Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
				valueField: 'id',
				displayField: 'value',
				forceSelection:true,
				typeAhead : false,
				editable : false
			},{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				name : 'programId',
				itemId : 'programBatch_programId',
				store:Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
				displayField:'valueCode',
				valueField:'id',
				width: 256,
				typeAhead:false,
				forceSelection:true,
				queryParam:'name',
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}'  +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'batchId',
				itemId:'programBatch_batchId',
				fieldLabel : getCourseTxCommonTranslation('BATCH'),
				disabled:true,
				store: Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
				valueField: 'id',
				displayField: 'value',
				typeAhead:false,
				forceSelection:true,
				width: 256,
				editable : false
			}]
		},
		{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype: 'textfield',
				name: 'masterSectionType',
				itemId:'masterSectionTypeItemId',
				hidden:true
			},{
				 xtype: 'customcombobox',
				 name: 'periodId',
				 itemId:'programBatch_periodId',
				 fieldLabel: getExaminationTranslation('PERIOD'),
				 store:Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
				 displayField:'value',
				 valueField:'id',
				 forceSelection:true,
				 typeAhead:false,
				 disabled:true,
				 width: 256,
				 editable : false
			 },{
				 xtype : 'customcombobox',
				 fieldLabel : getCourseTxCommonTranslation('COURSE_VARIANT'),
				 name : 'courseVariant',
				 itemId : 'courseVariantId',
				 store:Ext.create('Academia.store.attendance.facultyportal.AttendanceCourseVariantStore'),
				 displayField : 'courseVariantCode',
				 valueField : 'id',
				 typeAhead : true,
				 forceSelection : true,
				 editable : false
			 },{
				xtype: 'customcombobox',
				name: 'topics',
				itemId: 'topicsId',
				fieldLabel:getCourseTxCommonTranslation('TOPIC'),
				store:Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.Topic'),
				displayField : 'value',
				valueField : 'id',
				disabled:false,
				hidden:true
			},{
				xtype: 'multiselectcombofield',
				name: 'multiselectTopics',
				itemId: 'multipleTopicsId',
				fieldLabel:getCourseTxCommonTranslation('TOPIC'),
				store:Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.Topic'),
				displayField : 'value',
				valueField : 'id',
//				delimiter: null,
				typeAhead:true,
				forceSelection:true,
				cls: "commonAutoHeightMultiselectField"
				
			}]
		},{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype : 'datefield',
				fieldLabel : getProgramandcourseTranslation('FROM_DATE'),
				name : 'fromDate',
				itemId:'fromDate_Id',							
				//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
				endDateField : 'toDate_Id',
				vtype : 'daterange',
				editable : false,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			},{
				xtype : 'datefield',
				fieldLabel : getProgramandcourseTranslation('TO_DATE'),
				name : 'toDate',
				itemId:'toDate_Id',							
				//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
				startDateField : 'fromDate_Id',
				vtype : 'daterange',
				editable : false,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			}]
		},{
			xtype : 'fieldcontainer',
			width : 'auto',
			cls : 'windowBtnPos',
			items : [{
				xtype : 'button',
				text : getProgramandcourseTranslation('SHOW_CALENDAR'),
				itemId : 'viewSearchFilterId',
				buttonAlign : 'left',
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE
			},{
				xtype : 'button',
				text : getCommonTranslation('RESET'),
				itemId : 'resetSearchFilterId',
				buttonAlign : 'left',
				ui : 'CustomBtnCancel',
				scale : CONSTANTS.BUTTONSIZE,
			}]
		}
		]
	}]
});
