Ext.define('Academia.view.facultyPortal.detailScheduleFaculty.FacultyDetailedScheduleGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.facultydetailedschedulegrid',
	store: 'program.programDetails.programBatches.courseParameter.ExtendedTimeTableCBSGridStore',
	title: getProgramandcourseTranslation('DETAILED_SESSION'),
	border: true,
	frame:false,
	selType:'checkboxmodel',
	cls: 'horizontalScrollingFixed',
	headerFix:{
        headerFix: true,
        portalIdsWithStructure: {
            'detailedschedulefacultystructure': 2
        }
    },
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	listeners:{
		beforeselect:function(selModel,record,index){
			if(!isNullOrEmpty(selModel.view.up())){
				var gridItemId = selModel.view.up().getItemId();
				if(record.get('studentCourseAttendanceId') > 0){
					return false;
				}
			}
		}         
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'program.programDetails.programBatches.courseParameter.ExtendedTimeTableCBSGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'assignTopicButton',
		text: getProgramandcourseTranslation('ASSIGN_TOPIC'),
		disabled:true
	},{
		xtype: 'button',
		text:getCommonTranslation('EXPORT_REPORT'),
		itemId:'exportReport',
		tooltip :getCommonTranslation('EXPORT_REPORT'),
		disabled:true
	}],
	columns: [{
		header:getCommonTranslation('COURSE_NAME'),
		dataIndex: 'courseName',
		flex:.1,
		sortable:true
	},{
		header:getCommonTranslation('COURSE_VARIANT'),
		dataIndex: 'courseVariantName',
		flex:.1,
		sortable:true
	},{
		header:getCommonTranslation('SESSION_NUMBER'),
		dataIndex:'sessionNumber',
		flex:.1,
		sortable:true
	},{
		header:getCommonTranslation('SESSION_DATE'),
		dataIndex:'sessionDate',
		flex:.1,
		sortable:true,
		renderer:function(date) {
			return dateFormatRender(date);
		}
	},{
		header:getProgramandcourseTranslation('SESSION_TIME'),
		dataIndex:'sessionTime',
		flex:.1,
		sortable:true
	},{
		header:getCommonTranslation('FACULTY'),
		dataIndex: 'faculty',
		flex:.1,
		sortable:true,
	},{
		header:getProgramandcourseTranslation('TOPIC_DETAILS'),
		dataIndex: 'assignedTopicCount',
		flex:.1,
		sortable:true,
		renderer: function(val,rec,record,rowIndex,colIndex,store,view) {
    		if(record.data.assignedTopicCount > 0){
    			value="<a href='#'>View</a>"; 
        		return value;
    		} else {
        		return '';
    		}
    	},
	},{
		header:getCommonTranslation('ROOM'),
		dataIndex: 'roomName',
		flex:.1,
		sortable:true
	},{
		header:getCommonTranslation('WHETHER_ATTENDANCE_MARKED'),
		dataIndex: 'studentCourseAttendanceId',
		flex:.1,
		sortable:true,
		renderer: function(value) { 
			if(value > 0){
				return "<span style=\'color:green\'>Yes</span>";
			} else {
				return "<span style=\'color:red\'>No</span>";
			}
		}
	}]
});
