/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.fdmanagement.facultyPortal.FDMEOutwardGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.fdmeoutwardgrid',
    store: 'fdmanagement.FDManagementOutwardStore',
    title: getServiceRequestTranslation('FD_LIST_OF_SENT_ITEMS'),
    border: true,
    autoScroll: false,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    dockedItems: [{
        itemId: 'dockedItemsItemId',
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'fdmanagement.FDManagementOutwardStore',
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    tbar: [],
    columns: [{
        header: getServiceRequestTranslation('FD_ITEM_CATEGORY'),
        dataIndex: 'itemCategory',
        flex: 1,
        sortable: true,
        renderer: function(value, meta, record) {
            return value.value;
        }
    }, {
        header: getServiceRequestTranslation('FD_OUTWARD_NO'),
        dataIndex: 'outwardNo',
        flex: 1,
        sortable: true,
    }, {
        header: getServiceRequestTranslation('FD_DELIVER_TO'),
        dataIndex: 'deliverTo',
        flex: 1,
        sortable: true
    }, {
        header: getServiceRequestTranslation('FD_RECEIVER_CONTACT_NO'),
        dataIndex: 'receiverContactNo',
        flex: 1,
        sortable: true,
    }, {
        header: getServiceRequestTranslation('FD_NO_OF_PIECES'),
        dataIndex: 'noOfPackets',
        flex: 1,
        sortable: true,
    }, {
        header: getServiceRequestTranslation('FD_INTERNAL_PACKET_AND_DOCKET_NO'),
        dataIndex: 'fdOutwardItemDetails',
        flex: 1,
        sortable: true,
        renderer: function(value, meta, record) {
            if (!isNullOrEmpty(value)) {
                if (value.length > 0) {
                    return "<a href='#'>" + value.length + "</a>";
                }
            }
            return '0';
        }
    }, {
        header: getServiceRequestTranslation('FD_SENT_DATE'),
        dataIndex: 'sentDate',
        flex: 1,
        sortable: true,
        renderer: function(date) {
            return dateRender(date);
        }
    }, {
        header: getServiceRequestTranslation('FD_DELIVERY_STATUS'),
        dataIndex: 'packetStatus',
        flex: 1,
        sortable: true,
    }, {
        header: getServiceRequestTranslation('FD_DELIVERY_DATE'),
        dataIndex: 'deliveredDate',
        flex: 1,
        sortable: true,
        renderer: function(date) {
            return dateRender(date);
        },
    }, {
        header: getServiceRequestTranslation('FD_RETURN_DATE'),
        dataIndex: 'returnedDate',
        flex: 1,
        sortable: true,
        renderer: function(date) {
            return dateRender(date);
        },
        hidden: true
    }, {
        header: getServiceRequestTranslation('FD_INSURANCE_DETAILS'),
        dataIndex: 'isItemInsured',
        flex: 1,
        sortable: true,
        renderer: function(value, meta, record) {
            if (!isNullOrEmpty(value) && value)
                return "<a href='#'>View</a>";
            else
                return '-';
        }
    }, {
        header: getServiceRequestTranslation('FD_ATTACHMENTS'),
        dataIndex: 'documents',
        flex: 1,
        sortable: true,
        renderer: function(value, meta, record) {
            if (!isNullOrEmpty(value)) {
                if (value.length > 0) {
                    return "<a href='#'>" + value.length + "</a>";
                }
            }
            return '0';
        }
    }]
});