/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.feeandpayment.ConfigureFeeHeadsAddForm',{
	//extend:'Academia.view.common.CustomForm',
	extend:'Academia.view.common.IdGeneratorCustomForm',
	customFieldEntity:CONSTANTS.CONFIGURE_FEE_HEAD_CUSTOM_FIELD,
	alias: 'widget.configurefeeheadsaddform',
	autoScroll: false,
	frame: false,
	method: 'POST',
	standardSubmit: false,
	defaults: {
		width: 256,
		labelAlign: 'top'
	},
	plugins : "formlabelrequired",
	cls: 'x-form-fixed-footer-parent',
	items: [{
		xtype: 'hidden',
		name: 'id'
	},{
		xtype: 'hidden',
		name: 'feeHeadSequence',
		itemId: 'feeHeadSequence'
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width: 'auto',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'customcombobox',
			name: 'feeHead',
			itemId:'feeHead',
			fieldLabel: getFeeAndPaymentCommonTranslation('FEES_HEADS'),
			store: 'sponsorship.ManageConfiguredFeeHeadsStore',
			valueField: 'id',
			displayField: 'feeHeadName',
			minChars:3,
			queryParam:'qry',
			allowBlank: false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			name: 'organizationUnit',
			itemId:'organizationUnit',
			fieldLabel: getFeeAndPaymentCommonTranslation('LINKED_ALU'),
			store: 'feeandpayment.ALUnit',
			valueField: 'id',
			displayField: 'value',
			allowBlank: true,
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			name: 'costCentre',
			itemId:'costCentre',
			fieldLabel: getFeeAndPaymentCommonTranslation('COST_CENTER'),
			store: 'feeandpayment.CostCenterConfig',
			valueField: 'id',
			displayField: 'value',
			minChars:3,
			queryParam:'qry',
			listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.width = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                
            },
			allowBlank: false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			typeAhead:true,
			forceSelection:true
		}]
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width: 'auto',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'checkboxfield',
			width: 'auto',
			labelAlign: 'right',
			style:{
				marginTop:'25px'
			},
			boxLabel: getFeeAndPaymentCommonTranslation('FEE_HEAD_GROUPING_RECQUIRED'),
			name: 'feeHeadGroupingRecquired',
			itemId:'feeHeadGroupingRecquired',
			inputValue : true,
			uncheckedValue: false 
		},{
			xtype: 'customcombobox',
			name: 'groupingFeeHead',
			itemId:'groupingFeeHead',
			style:{
				marginLeft:'26px'
			},
			fieldLabel: getFeeAndPaymentCommonTranslation('FEE_HEAD_GROUP'),
			store: 'feeandpayment.GroupingFeeHead',
			valueField: 'id',
			displayField: 'value',
			minChars:3,
			queryParam:'qry',
			allowBlank: false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			typeAhead:true,
			disabled:true,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			name: 'poetMasterDetails',
			itemId:'poetMasterDetails', 
			style:{
				marginLeft:'0px'  
			},
			fieldLabel: getFeeAndPaymentCommonTranslation('POET'),
			store: 'feeandpayment.PoetDetailProjectNumberStore',
			valueField: 'id',
			displayField: 'projectNumber',
			minChars:3,
			queryParam:'qry',
			//allowBlank: false,
			hidden:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			typeAhead:true,
			//disabled:true,
			forceSelection:true
		}
		,{
			xtype: 'customcombobox',
			name: 'merchantItemCode',
			itemId:'merchantItemCode',
			matchFieldWidth:true,
			fieldLabel: getFeeAndPaymentCommonTranslation('MERCHANT_ITEM_CODE'),
			store: 'feeandpayment.MerchantItemCodeStore',
			valueField: 'id',
			displayField: 'value',
			allowBlank: true,
			typeAhead:true,
			hidden:true
		}]
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width: 'auto',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'customcombobox',
			name: 'amountType',
			itemId:'amountType',
			fieldLabel: getFeeAndPaymentCommonTranslation('AMOUNT_FOR'),
			store: 'feeandpayment.FeeAmount',
			valueField: 'id',
			displayField: 'value',
			allowBlank: false,
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'numberfield',
			name: 'feeAmount',
			itemId: 'feeAmount',
			fieldLabel: getFeeAndPaymentCommonTranslation('FEES_AMOUNT'),
			hideTrigger:true,
     	    mouseWheelEnabled:false,
     	    allowBlank: false,
     	    allowDecimals:true,
     	    regex: /[a-zA-Z0-9]+/,
			enforceMaxLength : true,
     	    minValue:0,
     	    maxLength: 10
		}]
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width: 'auto',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'customcombobox',
			name: 'parentFeeHead',
			itemId:'parentFeeHead',
			fieldLabel: getFeeAndPaymentCommonTranslation('PARENT_FEE_HEAD'),
			store: 'feeandpayment.ParentFeeHead',
			valueField: 'id',
			displayField: 'value',
			hidden:true,
			//allowBlank: false,
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'numberfield',
			name: 'parentFeeHeadAmount',
			itemId: 'parentFeeHeadAmount',
			fieldLabel: getFeeAndPaymentCommonTranslation('PARENT_FEE_HEAD_AMOUNT'),
			readOnly:true,
			hidden:true,
     	    enforceMaxLength : true,
     	    hideTrigger:true,
    	    mouseWheelEnabled:false
    
		}]
	},{
		xtype: 'numberfield',
		name: 'percentage',
		itemId: 'percentage',
		fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PERCENTAGE'),
		hidden:true,
		minValue:0,
		//maxValue: 100,
		enforceMaxLength : true,
		hideTrigger:true,
		mouseWheelEnabled:false,
		allowBlank: false
	},{
		xtype: 'textareafield',
		name: 'formulaForPercentage',
		width: 536,
		itemId:'formulaForPercentage',
		hidden:true,
		fieldLabel: getFeeAndPaymentCommonTranslation('FORMULA_FOR'),
		enforceMaxLength : true,
		maxLength:280
	},{
		//xtype: 'itemselector',
		xtype: 'customcombobox',
		name: 'feePayments',
		itemId:'feePayments',
		hidden:true,
		//style:{marginLeft:'-10px'},
		//width: 536,
		//maxHeight:200,
		//autoScroll:true,
		store : 'feeandpayment.FeePaymentMode',
		displayField: 'value',
		valueField: 'id',
		//fromTitle: getFeeAndPaymentCommonTranslation('AVAILABLE_PAYMENT_MODE'),
		//toTitle: getFeeAndPaymentCommonTranslation('SELECTED_PAYMENT_MODE'),
		//msgTarget: 'side',
		//delimiter: null,
		//buttons: ['top', 'add', 'remove', 'bottom']
	},{
		xtype:'hidden',
		name: 'feePaymentsId',
		itemId:'feePaymentsId'
	},/*{
		xtype: 'checkboxfield',
		width: 'auto',
		itemId:'whetherSplitPayment',
		labelAlign: 'right',
		boxLabel: getFeeAndPaymentCommonTranslation('ALLOW_SPLIT_PAYMENT_THROUGH_MM'),
		name: 'whetherSplitPayment',
		inputValue : true,
		uncheckedValue: false
	},*/{
		xtype:'fieldcontainer',
		layout:'hbox',
		width: 'auto',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'customcombobox',
			name: 'paymentPeriod',
			itemId:'paymentPeriod',
			fieldLabel: getFeeAndPaymentCommonTranslation('FEES_PERIODICTY'),
			store: 'feeandpayment.AmountPeriod',
			valueField: 'id',
			displayField: 'value',
			allowBlank: false,
			typeAhead:true,
			forceSelection:true
		},{
     	    
			xtype: 'numberfield',
			name: 'noOfFeePayment',
			itemId:'noOfFeePayment',
			fieldLabel: getFeeAndPaymentCommonTranslation('NO_OF_FEES_PAYMENTS'),
			hideTrigger:true,
     	    mouseWheelEnabled:false,
     	    allowDecimals:false,
     	    regex: /[a-zA-Z0-9]+/,
			enforceMaxLength : true,
     	    minValue:0,
     	    maxLength: 36,
     	    hidden:true,
     	   allowBlank: false
		}]
	},
	
	{
		xtype: 'customcombobox',
		name: 'effectiveEnrollmentDate',
		itemId:'effectiveEnrollmentDate',
		fieldLabel: getFeeAndPaymentCommonTranslation('EFFECTIVE_ENROLLMENT_DATE'),
		store: 'feeandpayment.EffectiveEnrollmentDate',
		valueField: 'id',
		displayField: 'value',
		allowBlank: true,
		typeAhead:true,
		forceSelection:true,
		 hidden:true
	},{
		xtype: 'checkboxfield',
		width: 'auto',
		labelAlign: 'right',
		boxLabel: getFeeAndPaymentCommonTranslation('ACCEPT_PDC'),
		name: 'whetherInstallPostDated',
		itemId:'whetherInstallPostDated',
		inputValue : true,
		//hidden:true,
		uncheckedValue: false 
	}
	,
	{
		xtype:'fieldcontainer',
		layout:'hbox',
		width: 'auto',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[{
		xtype: 'checkboxfield',
		width: 'auto',
		labelAlign: 'right',
		margin:'20 0 0 0',
		width: 256,
		boxLabel: getFeeAndPaymentCommonTranslation('REFUNDABLE'),
		name: 'whetherRefundAvailable',
		itemId:'whetherRefundAvailable',
		inputValue : true,
		uncheckedValue: false 

		},{	
			xtype: 'customcombobox',
			name: 'refundDrool',
			itemId:'refundDrool',
			fieldLabel: getFeeAndPaymentCommonTranslation('REFUND_DROOL'),
			store: 'feeandpayment.RefundDroolStore',
			valueField: 'code',
			hidden:true,
			displayField: 'value',
			allowBlank: true,
			typeAhead:true,
			forceSelection:true
		},{	
			xtype: 'customcombobox',
			name: 'refundDroolHostel',
			itemId:'refundDroolHostel',
			fieldLabel: getFeeAndPaymentCommonTranslation('REFUND_RULE'),
			store: 'feeandpayment.RefundDroolStore',
			valueField: 'code',
			hidden:true,
			displayField: 'value',
			allowBlank: true,
			typeAhead:true,
			forceSelection:true
		}]
	}

	
	
	
	,{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: {
			type: 'hbox'
		},
		defaults: {
			labelAlign: 'top',
			width:626
		},
		items: [{
			xtype      : 'radiogroup',
			fieldLabel : getFeeAndPaymentCommonTranslation('REFUNDABLE_NATURE'),
			itemId: 'refundableItemId',
			hidden:true,
			defaults: {
				flex: 1
			},
			layout: 'hbox',
			items: [{
			        	boxLabel:getFeeAndPaymentCommonTranslation('ADJUSTMENT_AGAINTS_FUTURE_BILLS'),
			        	name: 'refundableNature',
			        	inputValue: getFeeAndPaymentCommonTranslation('ADJUSTMENT_AGAINST_FEATURE_BILLS')
			        },{
			        	boxLabel:getFeeAndPaymentCommonTranslation('IMMEDIATE_PAYMENT'),
			        	name: 'refundableNature',
			        	inputValue: getFeeAndPaymentCommonTranslation('IMMEDIATE_PAYMENTS')
			        }]
		}]

	},{
		//xtype: 'itemselector',
		xtype: 'customcombobox',
		name: 'feeRefunds',
		itemId:'feeRefunds',
		//style:{marginLeft:'-10px'},
		hidden:true,
//		width: 536,
//		maxHeight:200,
//		autoScroll:true,
		store : 'feeandpayment.FeeRefundMode',
		displayField: 'value',
		valueField: 'id',
//		fromTitle: getFeeAndPaymentCommonTranslation('AVAILABLE_REFUND_MODES'),
//		toTitle: getFeeAndPaymentCommonTranslation('SELECTED_REFUND_MODES'),
//		msgTarget: 'side',
		delimiter: null,
//		buttons: ['top', 'add', 'remove', 'bottom']
	},{
		xtype:'hidden',
		name: 'feeRefundsId',
		itemId:'feeRefundsId'
	},{
		xtype: 'checkboxfield',
		width: 'auto',
		labelAlign: 'right',
		boxLabel: getFeeAndPaymentCommonTranslation('DISCOUNT'),
		name: 'discountCheckBox',
		itemId:'discountCheckBox',
		inputValue : true,
		uncheckedValue: false 
	},{
		xtype: 'customcombobox',
		name: 'payableDiscountFeehead',
		itemId:'payableDiscountFeehead',
		fieldLabel: getFeeAndPaymentCommonTranslation('DISCOUNT_FEE_HEAD'),
		store: 'feeandpayment.discount.DiscountFeeHeadStore',
		valueField: 'id',
		displayField: 'value',
		minChars:3,
		queryParam:'qry',
		allowBlank: true,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		typeAhead:true,
		forceSelection:true,
		hidden:true
	},{
		xtype: 'customcombobox',
		name: 'discountType',
		itemId:'discountType',
		fieldLabel: getFeeAndPaymentCommonTranslation('DISCOUNT_APPLICABILITY'),
		store: 'feeandpayment.DiscountType',
		valueField: 'id',
		displayField: 'value',
		typeAhead:true,
		forceSelection:true,
		hidden:true
	},
	{
		xtype: 'customcombobox',
		name: 'discountCostCentre',
		itemId:'discountCostCentre',
		fieldLabel: getFeeAndPaymentCommonTranslation('DISCOUNT_COST_CENTER'),
		store: 'feeandpayment.CostCenterConfig',
		valueField: 'id',
		displayField: 'value',
		minChars:3,
		queryParam:'qry',
		allowBlank: true,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		typeAhead:true,
		forceSelection:true
	},
	{
		xtype: 'checkboxfield',
		width: 'auto',
		//hidden:true,
		labelAlign: 'right',
		boxLabel: getFeeAndPaymentCommonTranslation('LATE_FEE'),
		name: 'whetherLateFee',
		itemId:'lateFeeCheckBox',
		inputValue : true,
		uncheckedValue: false 
	
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width: 'auto',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'nestedJsonCombo',
			name: 'lateFeeHead',
			itemId:'lateFees',
			fieldLabel: getFeeAndPaymentCommonTranslation('LATE_FEE_HEAD'),
			store: 'feeandpayment.LateFeeHeads',
			valueField: 'id',
			displayField: 'value',
			//allowBlank: false,
			typeAhead:true,
			forceSelection:true,
			hidden:true
		},{
			xtype: 'customcombobox',
			name: 'lateFeeType',
			itemId:'lateFeeType',
			fieldLabel: getFeeAndPaymentCommonTranslation('LATE_FEE_TYPE'),
			store: 'feeandpayment.LateFeeType',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true,
			hidden:true
			//allowBlank: false
		}]
		
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width: 'auto',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'numberfield',
			name: 'lateFeeAmount',
			itemId:'lateFeeAmount',
			fieldLabel: getFeeAndPaymentCommonTranslation('LATE_FEE_AMOUNT'),
			hideTrigger:true,
     	    mouseWheelEnabled:false,
     	    allowDecimals:true,
     	    regex: /[a-zA-Z0-9]+/,
     	    minValue:0,
     	    maxLength: 10,
			hidden:true
		},{
			xtype: 'numberfield',
			name: 'lateFeePercentage',
			itemId:'lateFeePercentage',
			fieldLabel: getFeeAndPaymentCommonTranslation('LATE_FEE_PERCENTAGE'),
			hideTrigger:true,
     	    mouseWheelEnabled:false,
     	    allowDecimals:false,
     	    regex: /[a-zA-Z0-9]+/,
     	    minValue:0,
     	    maxValue:100,
     	    maxLength: 3,
     	    hidden:true
		},{
			xtype: 'textfield',
			name: 'ruleApplicable',
			itemId:'ruleApplicable',
			hidden:true,
			fieldLabel: getFeeAndPaymentCommonTranslation('RULE_APPLICABLE')
		}]
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width: 'auto',
		itemId:'lateFeePeriodicityAndMaxLateFeeAmount',
		hidden:true,
		defaults: {
			labelAlign: 'top'
		},
		items:[{
				xtype: 'radiogroup',
				itemId:'lateFeePeriodicity',
				height: 60,
				//hidden:true,
				fieldLabel: getFeeAndPaymentCommonTranslation('LATE_FEE_PERIODICITY'),
				items:[{boxLabel:getCommonTranslation('ONE_TIME'), name: 'feePeriodicity', inputValue: 'ONE_TIME',checked:true},
		               { boxLabel:getFeeAndPaymentCommonTranslation('PER_DAY'), name: 'feePeriodicity', inputValue: 'PER_DAY_BASIS'}]
			},{
				xtype: 'numberfield',
				name: 'maximumLateFeeAmount',
				itemId:'maximumLateFeeAmount',
				fieldLabel: getFeeAndPaymentCommonTranslation('MAXIMUM_LATE_FEE_AMOUNT'),
				hideTrigger:true,
		 	    mouseWheelEnabled:false,
		 	    width: 256,
		 	    allowDecimals:false,
		 	    regex: /[a-zA-Z0-9]+/,
		 	    minValue:0,
		 	    maxLength: 10,
				hidden:true
			}]
	},/*{ 
		xtype: 'radiogroup',
		itemId:'lateFeePeriodicity',
		hidden:true,
		fieldLabel: getFeeAndPaymentCommonTranslation('LATE_FEE_PERIODICITY'),
		items:[{boxLabel:getFeeAndPaymentCommonTranslation('ONE_TIME'), name: 'feePeriodicity', inputValue: 'ONE_TIME',checked:true},
               { boxLabel:getFeeAndPaymentCommonTranslation('PER_DAY'), name: 'feePeriodicity', inputValue: 'PER_DAY_BASIS'}]
	},*/{
		xtype: 'textareafield',
		name: 'lateFeeRule',
		width: 536,
		itemId:'lateFeeRule',
		fieldLabel: getFeeAndPaymentCommonTranslation('LATE_FEES_RULE'),
		hidden:true,
		enforceMaxLength : true,
		maxLength:280
	//	allowBlank: false
	},{	
		xtype:'fieldcontainer',
		layout:'hbox',
		width: 'auto',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'numberfield',
			name: 'lateFeeOneTimeValue',
			itemId:'lateFeeOneTimeValue',				
			fieldLabel: getFeeAndPaymentCommonTranslation('LATE_FEE_ONE_TIME_VALUE'),
			hideTrigger:true,
     	    mouseWheelEnabled:false,
     	    allowDecimals:false,
     	    regex: /[a-zA-Z0-9]+/,
			enforceMaxLength : true,
     	    minValue:0,
     	    maxLength: 20,
			hidden:true
			//allowBlank: false
		},{
			xtype: 'numberfield',
			name: 'lateFeePerDayValue',
			itemId:'lateFeePerDayValue',
			fieldLabel: getFeeAndPaymentCommonTranslation('LATE_FEE_PER_DAY_VALUE'),
			hideTrigger:true,
     	    mouseWheelEnabled:false,
     	  //  allowBlank: false,
     	    allowDecimals:false,
     	    regex: /[a-zA-Z0-9]+/,
			enforceMaxLength : true,
     	    minValue:0,
     	    maxLength: 20,
			hidden:true
		}]
	},{  
		xtype: 'radiogroup',
		itemId:'proRatingBill',
		fieldLabel: getFeeAndPaymentCommonTranslation('PRO_RATE_BILLING'),
		items:[
		       { boxLabel:getFeeAndPaymentCommonTranslation('YES'), name: 'prorateBilling', inputValue: true},
		       { boxLabel:getFeeAndPaymentCommonTranslation('NO'), name: 'prorateBilling', inputValue: false,checked:true }
		       ]
	},{
			xtype: 'customcombobox',
			name: 'prorataPeriod',
			itemId:'prorataPeriod',
			fieldLabel: getFeeAndPaymentCommonTranslation('PRO_RATE_PERIOD_TYPE'),
			//store: 'feeandpayment.ProRatePeriodType',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true,
			hidden:true
			
	},{
		xtype: 'textareafield',
		name: 'remark',
		width: 536,
		itemId:'remark',
		fieldLabel: getFeeAndPaymentCommonTranslation('REMARKS'),
		enforceMaxLength : true,
		maxLength:225
	},{ 
		xtype:'fieldcontainer',
		//width:'100%',
		cls:'form-fixed-footer',
		items: [{
			xtype: 'button',
			action: 'Submit',
			text: getFeeAndPaymentCommonTranslation('SAVE'),
			formBind: true,
			itemId: 'SubmitBtn',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getFeeAndPaymentCommonTranslation('RESET'),
			ui: 'CustomBtnCancel',
			itemId: 'CancelBtn',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]	
});
