/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.feeandpayment.DiscountWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.discountwin',
	title:getFeeAndPaymentCommonTranslation('DISCOUNT'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	maxHeight: 600,
	items: [{
		xtype: 'form',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype: 'customcombobox',
			name: 'discountCode',
			itemId:'discountCode',
			fieldLabel: getFeeAndPaymentCommonTranslation('DISCOUNT_CODE'),
			store: 'feeandpayment.DiscountCode',
			valueField: 'id',
			displayField: 'value',
			allowBlank: false,
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'textareafield',
			name: 'rule',
			itemId:'discountRule',
			fieldLabel: getFeeAndPaymentCommonTranslation('DISCOUNT_RULE_DISCRIPTION'),
			enforceMaxLength : true,
			maxLength:200
		},{
			xtype: 'numberfield',
			name: 'discountValue',
			itemId:'discountValue',
			fieldLabel: getFeeAndPaymentCommonTranslation('DISCOUNT_VALUE'),
			allowBlank:false,
			hideTrigger:true,
			mouseWheelEnabled:false,
			allowDecimals:true,
			regex: /[a-zA-Z0-9]+/,
			//enforceMaxLength : true,
			minValue:0,
			 listeners: {
	                render: function(combo) {
	                return 	Ext.util.Format.number(combo.getValue(),'0,0.00');
	                	
	                }
	            },
			// maxLength: 20
			allowExponential : false
		},{
			xtype: 'textfield',
			name: 'discountOn',
			itemId:'discountOn',
			hidden:true,
			fieldLabel: getFeeAndPaymentCommonTranslation('DISCOUNT_ON')
		},{	
			xtype:'fieldcontainer',
			//width:'100%',
			//  cls:'windowBtnPos',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	}]
});