Ext.define('Academia.view.feeandpayment.DownloadPaymentPlanPersonsCoveredForm',{
	extend: 'Ext.form.FormPanel',
	alias: 'widget.downloadpaymentplanpersonscoveredform',
	autoScroll: false,
	frame: false,
	method: 'POST',
	standardSubmit: false,
//	cls:'customSearchPanel',
	defaults: {
		width: 256,
		labelAlign: 'top'
	},
//	plugins : "formlabelrequired",
	items: [{
		xtype: 'customcombobox',
		name: 'paymentPlanName',
		itemId:'paymentPlanName',
		width: 536,
		fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_PLAN_NAME'),
		store: 'feeandpayment.FindAllActiveAndMappedPaymentPlansByAcademyLocationsStore',
		valueField: 'id',
		displayField: 'value',
		typeAhead:true,
		forceSelection:true,
		allowBlank:false,
	},{
		xtype:'hidden',
		name:'id'
	},{	
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype: 'customcombobox',
			name: 'program',
			itemId: 'programId',
			width: 256,
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			store: 'feeandpayment.FindAllProgramsByPaymentPlanStore',
			displayField:'valueCode',
			valueField:'id',
			typeAhead:true,
			forceSelection:true,
			hideTrigger:false,	    
			triggerAction: 'all',
			minChars:3,
			queryParam:'programName',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'batch',
			disabled:true,
			fieldLabel: getFeeAndPaymentCommonTranslation('BATCH'),
			itemId:'batchId',
			store: 'program.programbatchdetail.BatchStore',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true
		},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype: 'customcombobox',
				name: 'seatTypeId',
				disabled:true,
				itemId:'seatTypeId',
				fieldLabel: getFeeAndPaymentCommonTranslation('SEAT_TYPE'),
				store: 'enquiry.ProgramBatchSeatTypeStore',
				valueField: 'id',
				displayField: 'value',
				queryMode : 'local',
				typeAhead:true,
				forceSelection:true
			},]
		}]	
	},{
		xtype:'fieldcontainer',
		width:'auto',
		layout: 'hbox',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		style:{
			'margin-left':'-32px !important'
		},
		items: [{
			xtype:'button',
			itemId:'paymentDownload',
			text:getFeeAndPaymentCommonTranslation('DOWNLOAD_TEMPLATE'),
			ui: 'CustomBtnSubmit',
			formBind:true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId:'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	
	}]
});
