/**
 * @author Rajkumar.patidar
 */

Ext.define('Academia.view.feeandpayment.FeeDoMappingWinForFaculty',{
	extend: 'Ext.window.Window',
	alias: 'widget.feedomappingwinforfaculty',
	title:getFeeAndPaymentCommonTranslation('APPLICABLE_FOR'),
	frame: true,
	autoScroll:true,
	modal:true,
	maxHeight: 600,
	items: [{
		xtype: 'form',
		method: 'POST',
		itemId:'feeplandetailform',
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype:'hidden',
			name:'feePlanId',
			itemId:'feePlanId'
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'textfield',
				name: 'feePlan',
				itemId:'feePlan',
				fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PLAN_ID'),
				allowBlank:true,
				readOnly:true
			},{
				xtype: 'datefield',
				itemId:'lastBilledDate',
				fieldLabel: getFeeAndPaymentCommonTranslation('LAST_AUTO_BILL_GENERATET'),
				name: 'lastBilledDate',
				editable:false,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.DATE_FORMAT
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype : 'customcombobox',
				name : 'academyLocation',
				itemId:'academyLocation',
				fieldLabel : getFeeAndPaymentCommonTranslation('ACADEMY_LOCATION'),
				store:'common.AcademyLocationByName',
				valueField : 'id',
				displayField : 'value',
				allowBlank : false,
				queryParam:'name',
//				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				forceSelection:true,
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
				xtype: 'textfield',
				name: 'mappingStatus',
				value:getFeeAndPaymentCommonTranslation('MAPPED'),
				itemId:'mappingStatus',
				readOnly:true,
				fieldLabel: getFeeAndPaymentCommonTranslation('MAPPING_STATUS'),
				allowBlank:true
			}] 

		},{	
			xtype:'fieldcontainer',
			//width:'100%',
			//  cls:'windowBtnPos',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	}]
});
