/**
 * @author Deepika Parmar
 */

Ext.define('Academia.view.feeandpayment.FeePlanDetailEditWindow',{
	extend: 'Ext.window.Window',
	alias: 'widget.feeplandetaileditwindow',
	title:getFeeAndPaymentCommonTranslation('FEE_PLAN'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	maxHeight: 600,
	width:700,	
	items: [{
		xtype: 'form',
		height:300,
		//bodyPadding: '5 5 5 5',
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			//width: 256
		},
		standardSubmit: false,
		items: [
			{
				xtype:'fieldcontainer',
				layout:'hbox',
				defaults:{
					width: 256,
					labelAlign: 'top',
				},
				items:[{
					xtype: 'textfield',
				    name: 'FeePlanId',
				    itemId:'FeePlanId',
				    readOnly:true,
				    fieldLabel: getCommonTranslation('ID'),			   
				},{
					xtype: 'textfield',
				    name: 'feePlanName',
				    itemId:'feePlanName',
				    fieldLabel: getCommonTranslation('FEE_PLAN_NAME'),	
				    allowBlank:false
				    
				}]
			},
			{
				xtype:'fieldcontainer',
				layout:'hbox',
				defaults:{
					width: 256,
					labelAlign: 'top',
				},
				items:[{
					xtype: 'datefield',
					name: 'validFrom',
					itemId:'validFrom',
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					
					vtype: 'daterange',
					minValue:new Date(),
					editable:false,
					fieldLabel: getCommonTranslation('VALID_FROM'),
					hidden:true
				},{
					xtype: 'datefield',
					name: 'validTill',
					itemId:'validTill',
					fieldLabel: getFeeAndPaymentCommonTranslation('VALID_TILL'),
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					vtype: 'daterange',
					minValue:new Date(),
					editable:false,
				}]
			},{
				xtype:'fieldcontainer',
				layout:'hbox',
				width: 'auto',
				defaults: {
					width: 256,
					labelAlign: 'top'
				},
				items:[{
					xtype:'checkbox',
					name:'generateAllBillsForSchools',
					itemId:'generateAllBillsForSchools',
					inputValue: true, 
					boxLabel:getCommonTranslation('GENERATE_ALL_BILLS_FOR_SCHOOL'),
					style:{marginTop:'24px !important'}
				},{
					xtype: 'datefield',
					name: 'billGenerationDate',
					itemId:'billGenerationDate',
					hidden:true,
					fieldLabel: getCommonTranslation('BILL_GENERATION_DATE'),
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					vtype: 'daterange',
					editable:false,
				}]
			},{
				xtype:'fieldcontainer',
				layout:'hbox',
				width: 'auto',
				defaults: {
					width: 256,
					inputValue: true, 
				},
				items:[{
					xtype:'checkbox',
					name:'whetherProrataBillingForSchool',
					itemId:'whetherProrataBillingForSchool',
					boxLabel:getCommonTranslation('WHETHER_PRO_RATA_FOR_SCHOOL')
				},{
					xtype:'checkbox',
					name:'isBillCancelationOnDeletePersonCover',
					itemId:'isBillCancelationOnDeletePersonCover',
					width: 360,
					boxLabel:getCommonTranslation('BILL_CANCELLATION_AFTER_PERSON_COVERED_REMOVAL')
				}]
			},{	
			  xtype:'fieldcontainer',
			  //width:'100%',
			  cls:'windowBtnPos',
			  items: [{
			    	 xtype: 'button',
					 action: 'Submit',
					 text: getFeeAndPaymentCommonTranslation('SAVE'),
					 formBind: true,
					 itemId: 'SubmitBtn',
					 ui: 'CustomBtnSubmit',
					 scale: CONSTANTS.BUTTONSIZE
			       },
			       {
						xtype: 'button',
						text: getCommonTranslation('CANCEL'),
						itemId: 'cancelBtn',
						ui: 'CustomBtnCancel',
						scale: CONSTANTS.BUTTONSIZE   
					}]
		}]	
	}]
});