/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.feeandpayment.FeePlanDetailForm',{
	extend: 'Ext.form.FormPanel',
	customFieldEntity:CONSTANTS.FEE_PLAN_CUSTOM_FIELD,
	alias: 'widget.feeplandetailform',
	itemId:'feeplanformid',
	frame: true,
	method: 'POST',
	standardSubmit: false,
	defaults: {
		width: 256,
		labelAlign: 'top'
	},
	plugins : "formlabelrequired",
	items: [{
		xtype: 'hidden',
		name: 'id'
	},{
		xtype:'hidden',
		name:'feeId'
	},{
		xtype:'hidden',
		name:'feePlanTypeId',
		itemId:'feePlanTypeId'
	},{
		xtype:'hidden',
		name:'serviceProvidedId',
		itemId:'serviceProvidedId'
	},{
		xtype:'hidden',
		name:'whetherProrataBillingForSchool',
		itemId:'whetherProrataBillingForSchool'
	},{
		xtype:'hidden',
		name:'billGenerationDateRaw',
		itemId:'billGenerationDateRaw'
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width: 'auto',
		defaults: {
			width: 256,
			labelAlign: 'top',
			xtype: 'displayfield'
		},
		items:[{
			name: 'feePlanId',
			itemId:'feePlanId',
			fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PLAN_ID')
		},{
			name: 'feePlanType',
			itemId:'feePlanType',
			fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PLAN_TYPE')
		},{
			name: 'feePlanName',
			itemId:'feePlanName',
			fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PLAN_NAME')
		},{
			name:'generateAllBillsForSchools',
			itemId:'generateAllBillsForSchools',
			fieldLabel:getCommonTranslation('GENERATE_ALL_BILLS_FOR_SCHOOL')
		},{
			name: 'billGenerationDate',
			itemId:'billGenerationDate',
			fieldLabel: getCommonTranslation('BILL_GENERATION_DATE')
		}]
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width: 'auto',
		defaults: {
			width: 256,
			labelAlign: 'top',
			xtype: 'displayfield'
		},
		items:[{
			name: 'currency',
			itemId:'currency',
			fieldLabel: getFeeAndPaymentCommonTranslation('CURRENCY')

		},{
			name: 'validFrom',
			itemId:'validFrom',
			fieldLabel: getCommonTranslation('VALID_FROM'),
			hidden:true
		},{
			name: 'validTill',
			itemId:'validTill',
			fieldLabel: getFeeAndPaymentCommonTranslation('VALID_TILL')
		},{
			name: 'serviceId',
			itemId:'serviceProvided',
			hidden:true,
		},{
			name: 'course',
			itemId:'courseId',
			hidden:true,
			fieldLabel: getFeeAndPaymentCommonTranslation('Course')
		},{
			name:'whetherProrataBillingForSchoolEdit',
			itemId:'whetherProrataBillingForSchoolEdit',
			fieldLabel:getCommonTranslation('WHETHER_PRO_RATA_FOR_SCHOOL')
		},{
			name:'isBillCancelationOnDeletePersonCover',
			itemId:'isBillCancelationOnDeletePersonCover',
			fieldLabel:getCommonTranslation('BILL_CANCELLATION_AFTER_PERSON_COVERED_REMOVAL')
		}]

	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width: 'auto',
		defaults: {
			width: 256,
			labelAlign: 'top',
			xtype: 'displayfield'
		},
		items:[{
			name: 'applicableFor',
			itemId:'applicableForId',
			hidden:true,
			fieldLabel: getFeeAndPaymentCommonTranslation('APPLICABLE_FOR')
		},{
			xtype:'hidden',
			name:'wheatherServiceReceivableId',
			itemId:'wheatherServiceReceivableId'
		}]
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width: 'auto',
		items: [{
			xtype:'button',
			text:getCommonTranslation('EDIT_DETAILS'),
			ui:'CustomBtnCancel',
			itemId:'feePlanEditBtn',
			scale: CONSTANTS.BUTTONSIZE,
			cls: 'btn-with-no-icon'
		}]
	}]	
});
