/**
 * @author Rajkumar Patidar
 */
Ext.define('Academia.view.feeandpayment.FeeProjectedBillingReportForm', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.feeprojectedbillingreportform',
	autoScroll: true,
	frame: false,
	method : 'POST',
	standardSubmit : false,
	height:window.innerHeight-250,
	defaults: {
		labelAlign:'top',
		width: 256
	},
	plugins : "formlabelrequired",
	items: [{
		xtype:'panel',
		width:'100%',
		cls:'customSearchPanel',
		items:[{
			xtype:'hidden',
			name:'id'
		},{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype : 'multiselectcombofield',
				name : 'academyLocation',
				itemId:'academyLocationId',
				width: 536,
				fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
				store:'common.AcademyLocationNameSeparated',
				valueField : 'id',
				displayField : 'value',
				allowBlank : false,
				queryParam:'qry',
				typeAhead:true,
				enableKeyEvents  : 'true',
				hideTrigger:false,
				editable:false,
				forceSelection:true,
				cls:'commonAutoHeightMultiselectField',
			}]
		},{
			xtype: 'radiogroup',
			itemId:'searchBYItemId',
			columns: 2,
			vertical: true,
			items: [
			        { boxLabel: getFeeAndPaymentCommonTranslation('STUDENT'), name: 'searchBY', inputValue: true,checked:true},
			        { boxLabel: getFeeAndPaymentCommonTranslation('PROGRAM'), name: 'searchBY', inputValue: false}
			        ]
		},{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype: 'customcombobox',
				name: 'student',
				itemId:'student',
				width: 536,
				fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
				store: 'feeandpayment.managebill.Student',
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'studentNameOrCode',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				allowBlank : false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{studentCode}/{studentName}' +
						'</div>';
					}
				}
			}]
		},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			hidden:true,
			itemId:'searchByFeePlanType',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{  
				xtype: 'customcombobox',
				name: 'feePlanType',
				itemId:'feePlanType',
				fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PLAN_TYPE'),
				store: 'feeandpayment.dashboardAndReports.FeePlanTypeProgramAndService',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true,
				allowBlank:false
			},{
				xtype: 'customcombobox',
				name: 'feePlan',
				itemId:'feePlan',
				fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PLAN_NAME'),
				store: 'feeandpayment.dashboardAndReports.FeePlanNameProgramAndService',
				valueField: 'id',
				displayField: 'value',
				disabled:true,
				typeAhead:true,
				forceSelection:true,
				allowBlank:false
			}]
		},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getCommonTranslation('BILL_DATE_FROM'),
				name : 'startDate',
				itemId : 'startDate',
				endDateField : 'tillDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
				vtype : 'daterange',
				allowBlank:true
			},{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getCommonTranslation('BILL_TO_DATE'),
				name : 'tillDate',
				itemId : 'tillDate',
				startDateField : 'startDate',
				listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            //--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
				allowBlank:true,
				vtype : 'daterange'
			}]	
		},{
			xtype: 'panel',
			cls: 'customSearchPanelBtnsFieldContainerCls',
			width: 'auto',
			items:[{  
				xtype: 'button',
				itemId: 'searchBtn',
				text: getCommonTranslation('SEARCH'),
				ui:'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
				xtype: 'button',
				itemId: 'resetBtn',
				text: getCommonTranslation('RESET'),
				ui:'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]	
		}]
	  },{
		  xtype : 'projectedbillingreportgrid',  // by default no change
		  width:'100%',
		  itemId: 'projectedbillingreportgrid' 
	  },
	  {

		  xtype : 'studentprojectedbillingreportgrid',  // by default no change
		  width:'100%',
		  itemId: 'studentprojectedbillingreportgrid',
		  hidden : true
	  
	  }]
	});