/**
 * @author Rajkumar Patidar
 */
Ext.define('Academia.view.feeandpayment.ManageFeeSearchForm', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.managefeesearchform',
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	method : 'POST',
	standardSubmit : false,
	defaults: {
		labelAlign:'top',
		width: 256
	},
	plugins : "formlabelrequired",
	items: [{
			xtype:'hidden',
			name:'id'
		},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype: 'customcombobox',
				name: 'programId',
				itemId: 'programId',
				width: 536,
				fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				store:'program.ProgramCodeOrNameSmartSearch',
				displayField:'valueCode',
				valueField:'id',
				typeAhead:true,
				forceSelection:true,
				hideTrigger:false,	    
				triggerAction: 'all',
				minChars:3,
				queryParam:'qry',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'batchId',
				disabled:true,
				fieldLabel: getFeeAndPaymentCommonTranslation('BATCH'),
				itemId:'batchId',
				store: 'enquiry.AcademicBatchStore',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true
			}]
		},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype: 'customcombobox',
				name: 'seatTypeId',
				disabled:true,
				itemId:'seatTypeId',
				fieldLabel: getFeeAndPaymentCommonTranslation('SEAT_TYPE'),
				store: 'enquiry.ProgramBatchSeatTypeStore',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true
			},{  
				xtype: 'customcombobox',
				name: 'feePlanType',
				itemId:'feePlanType',
				fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PLAN_TYPE'),
				store: 'feeandpayment.FeePlanTypeStore',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true
			},{
				xtype: 'customcombobox',
				name: 'feePlan',
				itemId:'feePlan',
				disabled:true,
				fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PLAN_NAME'),
				store: 'feeandpayment.FeePlan',
				valueField: 'id',
				displayField: 'value',
				forceSelection:true,
				queryParam:'query',
				minChars:3,
				typeAhead:false,
				triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
				triggerAction: '',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							//picker.minWidth = picker.up('combobox').getSize().width;
							var combo = picker.up('combobox');
							picker.setWidth(combo.getWidth());
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND')
				}
			}]	
		},{	 
			xtype:'fieldset',
			title:getFeeAndPaymentCommonTranslation('MORE_FILTERS'),
			layout:'vbox',
			frame:true,	
			collapsible:true,
			collapsed:true,
			width:'100%',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			style: {
				marginTop: '40px!important'
			},
			items:[{
				xtype:'fieldcontainer',
				width: '100%',
				layout : 'hbox',
				defaults: {
					labelAlign:'top',
					width: 256
				},
				items:[{
					xtype: 'customcombobox',
					name: 'stage',
					itemId:'stage',
					fieldLabel: getFeeAndPaymentCommonTranslation('STAGE'),
					store: 'feeandpayment.FeePlanStageType',
					valueField: 'id',
					displayField: 'value',
					typeAhead:true,
					forceSelection:true
				},{
					xtype: 'customcombobox',
					name: 'mappingStatus',
					itemId:'mappingStatus',
					fieldLabel: getFeeAndPaymentCommonTranslation('MAPPING_STATUS'),
					store: 'feeandpayment.MappingStatus',
					valueField: 'id',
					displayField: 'value',
					typeAhead:true,
					forceSelection:true

				},{
					xtype: 'customcombobox',
					name: 'approvalStatus',
					itemId:'approvalStatus',
					fieldLabel: getFeeAndPaymentCommonTranslation('APPROVAL_STATUS'),
					store: 'feeandpayment.FeePlanStatus',
					valueField: 'id',
					displayField: 'value',
					typeAhead:true,
					forceSelection:true

				}]
			},{
				xtype:'fieldcontainer',
				width: '100%',
				layout : 'hbox',
				defaults: {
					labelAlign:'top',
					width: 256
				},
				items:[{
					xtype: 'customcombobox',
					name: 'currency',
					itemId:'currency',
					fieldLabel: getFeeAndPaymentCommonTranslation('CURRENCY'),
					store: 'feeandpayment.FeeCurrencyStore',
					valueField: 'id',
					displayField: 'name',
					typeAhead:true,
					forceSelection:true
				}]
			}]
		},{
			xtype: 'fieldcontainer',
			cls: 'customSearchPanelBtnsFieldContainerCls',
			width: 'auto',
    		layout : {
    			type : 'hbox'
    		},
			items:[{  
				xtype: 'button',
				itemId: 'searchBtn',
				text: getCommonTranslation('SEARCH'),
				ui:'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				itemId: 'resetBtn',
				text: getCommonTranslation('RESET'),
				ui:'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]	
		}]
	});
