/**
 *  @author P kumar
 */

Ext.define('Academia.view.feeandpayment.PaymentPlanProgramGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.paymentplanprogramgrid',
	title : getCommonTranslation('PROGRAM'),
	store: 'feeandpayment.ALProgramList',
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	dockedItems: [{
        xtype : 'toolbar',
        dock : 'bottom',
        items : [ {
            xtype : 'custompagingtoolbar',
            plugins:['pagesize'],
            store : 'feeandpayment.ALProgramList',
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo : true
        }]
    }],
	//autoScroll: true,
	height:380,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		loadMask: false
	},
	border: true,
	tbar: [{
		xtype:'button',
		itemId: 'nextButton',
		text:getCommonTranslation('NEXT'),
		tooltip: getCommonTranslation('NEXT')
	},{

		xtype: 'button',
		text: getCommonTranslation('SUBMITKYS'),
		itemId: 'submitDefaultPaymentMapping',
		buttonAlign: 'left',
		hidden : true,
		scale: CONSTANTS.BUTTONSIZE
	
	},{
		xtype: 'button',
		text: getCommonTranslation('RESET'),
		itemId: 'resetBtn',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'customcombobox',
		name: 'programsearchcombo',
		itemId:'programsearchcombo',
		store: 'feeandpayment.ALProgramSearchCombo',
		valueField: 'id',
		displayField: 'value',
		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		enableKeyEvents  : 'true',
		queryParam:'programName',
		queryMode: 'remote',
		width: 256,
		typeAhead : true,
		forceSelection:true,
		hideTrigger:false,
		triggerAction: '',
		minChars:3,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}'  +
				'</div>';
			}
		}
	},{
		xtype:'fieldcontainer',
		width:'100%',
		layout : 'hbox',
		items: [{
			xtype: 'radiogroup',
			itemId: 'defaultPaymentPlanMapping',
			name:'defaultPaymentPlanMapping',
			labelAlign:'top',
			width:'100%',
			vertical: false,
			allowBlank : false,
			layout: {
				type: 'hbox'
			},
			items: [{
				boxLabel: getFeeAndPaymentCommonTranslation('GENERIC_MAPPING'),
				itemId: 'genericMapping',
				name: 'defaultMapping',
				inputValue: false,
				checked: true
			},{
				boxLabel: getFeeAndPaymentCommonTranslation('SET_DEFAULT_PAYMENT_PLAN'),
				itemId: 'defaultPaymentPlan',
				name: 'defaultMapping',
				inputValue: true
			}]
		}]
	}],
	columns: [{
		header : getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyLocationName',
		flex : 1	 
	},{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex : 1	 
	}]
});