/**
 *  @author Amit G
 */


Ext.define('Academia.view.feeandpayment.ProjectedSponsorStatementReportGrid', {
	//extend : 'Ext.grid.Panel',
	 extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.projectedsponsorstatementreportgrid',
	store : 'feeandpayment.FeeAndPaymentProjectedSponsorStatementGridStore',
	 title: getCommonTranslation('LIST_OF_STUDENT'),
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	 features: [{
	        ftype: 'summary',
	        showSummaryRow:CONSTANTS.SHOW_SUMMARY_ROW 
	    }],
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.FeeAndPaymentProjectedSponsorStatementGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	 initComponent: function() {
         var grid=this;                   
         grid.addExportToolBarItems(grid);
         this.callParent(arguments);     
  },
	tbar: [],
	columns: [{
		header : getFeeAndPaymentCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentCode',
		flex:1,
		summaryRenderer: function(value, summaryData, dataIndex) {
			if(portalId!=3){
				return getFeeAndPaymentCommonTranslation('TOTAL');
			}
	      }
	},{
		header : getFeeAndPaymentCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('PROGRAM'),
		dataIndex : 'studentProgram',
		flex:1,
	},{
		header : getFeeAndPaymentCommonTranslation('BATCH'),
		dataIndex : 'studentIntake',
		flex:1,
	},{
		header : getFeeAndPaymentCommonTranslation('FEE_HEAD'),
		dataIndex : 'feeHead',
		flex:1,
	},{
		header : getFeeAndPaymentCommonTranslation('FEE_AMOUNT'),
		dataIndex : 'specificAmount',
		flex : 1,
		summaryType: 'sum',
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("feeCurrencyId"));
			}
		}
	}]
});
