/**
 *  @author Prakash.Soni
 */

Ext.define('Academia.view.feeandpayment.StudentEnrollmentPaymentList', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.studentenrollmentpaymentlist',
	store : 'feeandpayment.StudentEnrollmentPaymentListing',
	title: getCommonTranslation('STUDENT_PAYMENT_PLAN_ENROLLMENT'),
	border: true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.StudentEnrollmentPaymentListing',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	tbar: [{
		xtype : 'button',		
		text:getCommonTranslation('ENROLL'),
		itemId:'saveEnrollmentDetailItemId'
	},{
		xtype : 'button',		
		text:getCommonTranslation('UNENROLL'),
		itemId:'deEnrollmentCourseItemId',
	},{
		xtype : 'button',		
		text:getCommonTranslation('APPROVE'),
		itemId:'approveStudentEnrollment',
		hidden:true
	},{
		xtype : 'button',		
		text:getCommonTranslation('REJECT'),
		itemId:'rejectStudentEnrollment',
		hidden:true
	}],
	columns: [{
		header : getCommonTranslation('PAYMENT_PLAN_ID'),
		dataIndex : 'paymentPlanId',
		flex:1,
		hidden:true
	},
	{
		header : getCommonTranslation('ENROLLED_BY'),
		dataIndex : 'enrolledBy',
		flex:1,
		hidden:true
	},
	{
		header : getCommonTranslation('PAYMENT_PLAN'),
		dataIndex : 'paymentPlanName',
		flex:1
	},{
		header : getCommonTranslation('INSTALLMENTS'),
		dataIndex : 'noOfInstallments',
		flex:1
	},{
		header : getCommonTranslation('STUDENTS_ENROLLED'),
		dataIndex : 'studentsEnrolled',
		flex:1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.studentsEnrolled)) {
				if(record.data.studentsEnrolled==0){
					return value;  
				} else {
					return '<a href=#>'+record.data.studentsEnrolled+'</a>';
				}
			} else {
				return "-";   
			} 
		}
	},{
		header : getCommonTranslation('MAPPED_TO'),
		dataIndex : 'mappedTo',
		flex : 1,
		renderer:function(value){
			return  '<a href="#">View</a>';
		}
	},{
		header : getFeeAndPaymentCommonTranslation('STATUS'),
		dataIndex : 'enrollmentStatus',
		flex : 1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(val == 'STUDENT_ENROLLED'){
				return 'Auto-enrolled'
			}
			else if(val == "ENROLLED"){
				return 'Admin Enrolled'
			}
			else if(val =="WAITING_FOR_APPROVAL"){
				return 'Requested';
			}
			else if(val =="APPROVED"){
				return 'Approved';
			}
			else if(val =="REJECTED"){
				return 'Rejected';
			}
			else{
				return val; 
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('EFFECTIVE_INTEREST_CALCULATION_DATE_MONTH'),
		dataIndex : 'effectiveIntrestDate',
		flex : 1,
		renderer:function(val){		
			return dateRender(val);
		}
	}]
});