/**
 * @author Prakash Soni
 */
Ext.define('Academia.view.feeandpayment.StudentEnrollmentPaymentSearchForm', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.studentenrollmentpaymentsearchform',
	store : 'feeandpayment.PaymentPlanStudentEnrolStore',
	//title:getCommonTranslation('QUICK_SEARCH'),
	autoScroll: false,
	method: 'POST',
	standardSubmit: false,
	cls:'customSearchPanel',
	plugins : "formlabelrequired",
	items: [{
			xtype:'hidden',
			name:'id'
		},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype: 'customcombobox',
				name: 'fnpAdmissionStudentName',
				itemId:'fnpAdmissionStudentNameItemId',
				allowBlank:true,
				hidden:false,
				width: 536,
				fieldLabel: getCommonTranslation('ADMISSIONID_STUDENTID_STUDENTNAME'),
				store: Ext.create('Academia.store.coursetransaction.studentenrollment.studentenrollmentdetail.StudentIdByAdmissionCodeBySmartSearch'),
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'name',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{studentCode}/{studentName}' +
						'</div>';
					}
				}
			
				/*
				xtype: 'textfield',
				name: 'fnpAdmissionStudentName',
				itemId:'fnpAdmissionStudentNameItemId',
				fieldLabel: getCommonTranslation('ADMISSIONID_STUDENTID_STUDENTNAME')
			*/}]	
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			cls: 'customSearchPanelBtnsFieldContainerCls',
			width: 'auto',
			items:[{  
				xtype: 'button',
				itemId: 'searchBtn',
				text: getCommonTranslation('SEARCH'),
				ui:'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				itemId: 'resetBtn',
				text: getCommonTranslation('RESET'),
				ui:'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]	
		}]
	});
