/**
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.feeandpayment.accountingConfiguration.AccountingConfigurationList', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.accountingconfigurationlist',
	store : 'feeandpayment.accountingConfiguration.AccountingConfigurationList',
	border: true,
	title: getCommonTranslation('ACCOUNTING_CONFIGURATION'),
	isGridConfigurable: true,
	enableColumnHide: false, 
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.accountingConfiguration.AccountingConfigurationList',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getFeeAndPaymentCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getFeeAndPaymentCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getFeeAndPaymentCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getFeeAndPaymentCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header : getCommonTranslation('CONFIGURATION_NAME'),
		dataIndex : 'configName',
		flex : 1 
	},{
		header : getCommonTranslation('DESCRIPTION'),
		dataIndex : 'configDesc',
		flex : 1	
	},{
		header : getCommonTranslation('CREATED_BY'),
		dataIndex : 'userName',
		flex : 1
	},{
		header : getCommonTranslation('CREATED_DATE'),
		dataIndex : 'createdDate',
		flex : 1,
		renderer:function(val){		
			return dateRender(val);
		}
	},{
		header : getCommonTranslation('LAST_MODIFIED_DATE'),
		dataIndex : 'lastModifiedDate',
		flex : 1,
		renderer:function(val){		
			return dateRender(val);
		}
	},{
		header : getCommonTranslation('VALID_TILL'),
		dataIndex : 'validTill',
		flex : 1,
		renderer:function(val){		
			return dateRender(val);
		}
	}]
});