/**
 *  @author Rajkumar.patidar
 */

Ext.define('Academia.view.feeandpayment.adjustment.BillList', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.billlist',
	title : getFeeAndPaymentCommonTranslation('BILL_RECEIVABLE_LABEL'),
	store : 'feeandpayment.adjustment.BillToBillAdjustment',
	border: true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		loadMask: false
	},
	/*dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.adjustment.BillToBillAdjustment',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
    }],*/
	tbar: [{
		itemId: 'nextBtn',
		disabled:true,
		text:getCommonTranslation('NEXT'),
		tooltip: getCommonTranslation('NEXT')
	},{
		xtype: 'button',
		itemId: 'cancelSettlementLink',
		text:getFeeAndPaymentCommonTranslation('CANCEL_SETTLEMENT'),
		tooltip: getFeeAndPaymentCommonTranslation('CANCEL_SETTLEMENT')
	}],
	columns: [{
		header : getFeeAndPaymentCommonTranslation('BILL_NO'),
		dataIndex : 'billNo',
		flex : 1	 
	},{
		header : getFeeAndPaymentCommonTranslation('BILLING_DATE'),
		dataIndex : 'billingDate',
		flex : 1,
		renderer: function(date) {
			return dateRender(date);
		}
	},{
		header : getFeeAndPaymentCommonTranslation('DUE_DATE'),
		dataIndex : 'dueDate',
		flex : 1,
		renderer: function(date) {
			return dateRender(date);
		}
	},{
		header : getFeeAndPaymentCommonTranslation('FEE_HEAD'),
		dataIndex : 'feeHeadName',
		flex : 1	
	},{
		header : getFeeAndPaymentCommonTranslation('BILLING_AMOUNT'),
		dataIndex : 'totalAmount',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}                    
		}  
	},{
		header : getFeeAndPaymentCommonTranslation('ALREADY_ADJUSTED_AMOUNT'),
		dataIndex : 'totalAdjustedAmount',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}                    
		} 
	},{
		header : getFeeAndPaymentCommonTranslation('BALANCE_AMOUNT'),
		dataIndex : 'totalBalanceAmount',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}                    
		} 
	},{
		header : getFeeAndPaymentCommonTranslation('VIEW_ADJUSTMENTS'),
		dataIndex : 'viewAdjustments',
		flex : 1,
		renderer:function(){
			return  '<a href="#">View</a>';
		}
	}]
});